/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.transform.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.transform.Transformer;
import com.vmware.vise.util.Pair;
import com.vmware.vise.util.collection.CollectionUtil;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;

public final class PropertyValueSubstitutionTransformer
implements Transformer<Constraint, Constraint> {
    private static final String TYPE_VM = "VirtualMachine";
    private static final String PROP_TOOLS_STATUS = "guest.toolsVersionStatus2";
    private static final String PROP_TOOLS_STATUS_ALIAS = "toolsVersionStatus";
    private static final String VALUE_CURRENT = "guestToolsCurrent";
    private static final String VALUE_SUPPORTED_NEW = "guestToolsSupportedNew";
    private static final String VALUE_TOO_OLD = "guestToolsTooOld";
    private static final String VALUE_TOO_BLACK_LISTED = "guestToolsTooBlackListed";
    private static final String VALUE_NEED_UPGRADE = "guestToolsNeedUpgrade";
    private final Map<Pair<String, String>, Map<String, List<String>>> _substitutionRegistry;

    public PropertyValueSubstitutionTransformer() {
        ImmutableMap toolsVersionStatusValues = ImmutableMap.builder().put((Object)VALUE_CURRENT, (Object)ImmutableList.of((Object)VALUE_CURRENT, (Object)VALUE_SUPPORTED_NEW)).put((Object)VALUE_TOO_OLD, (Object)ImmutableList.of((Object)VALUE_TOO_OLD, (Object)VALUE_TOO_BLACK_LISTED, (Object)VALUE_NEED_UPGRADE)).build();
        this._substitutionRegistry = ImmutableMap.builder().put((Object)new Pair((Object)TYPE_VM, (Object)PROP_TOOLS_STATUS, true), (Object)toolsVersionStatusValues).put((Object)new Pair((Object)TYPE_VM, (Object)PROP_TOOLS_STATUS_ALIAS, true), (Object)toolsVersionStatusValues).build();
    }

    @Override
    public Transformer.Result<Constraint> transform(Constraint constraint) {
        TransformationContext context = new TransformationContext();
        Constraint transformedConstraint = this.transform(constraint, context);
        return new Transformer.Result<Constraint>(transformedConstraint, context.isTransformed);
    }

    protected Constraint transform(Constraint constraint, TransformationContext context) {
        if (constraint == null) {
            return constraint;
        }
        if (constraint instanceof PropertyConstraint) {
            PropertyConstraint propertyConstraint = (PropertyConstraint)constraint;
            Constraint transformedConstraint = this.transform(propertyConstraint, context);
            return transformedConstraint;
        }
        if (constraint instanceof RelationalConstraint) {
            Constraint transformedRelatedConstraint;
            RelationalConstraint relationalConstraint = (RelationalConstraint)constraint;
            relationalConstraint.constraintOnRelatedObject = transformedRelatedConstraint = this.transform(relationalConstraint.constraintOnRelatedObject, context);
            return relationalConstraint;
        }
        if (constraint instanceof CompositeConstraint) {
            CompositeConstraint compositeConstraint = (CompositeConstraint)constraint;
            if (ArrayUtils.isEmpty(compositeConstraint.nestedConstraints)) {
                return compositeConstraint;
            }
            for (int i = 0; i < compositeConstraint.nestedConstraints.length; ++i) {
                Constraint transformedNestedConstraint;
                compositeConstraint.nestedConstraints[i] = transformedNestedConstraint = this.transform(compositeConstraint.nestedConstraints[i], context);
            }
            return compositeConstraint;
        }
        return constraint;
    }

    private Constraint transform(PropertyConstraint constraint, TransformationContext context) {
        if (!this.isSupportedComparator(constraint.comparator)) {
            return constraint;
        }
        Pair substitutionPairKey = new Pair((Object)constraint.targetType, (Object)constraint.propertyName, true);
        Map<String, List<String>> substitutionValueMap = this._substitutionRegistry.get(substitutionPairKey);
        if (substitutionValueMap == null) {
            return constraint;
        }
        String stringComparableValue = String.valueOf(constraint.comparableValue);
        List<String> substitutionValueList = substitutionValueMap.get(stringComparableValue);
        if (CollectionUtil.isNullOrEmpty(substitutionValueList)) {
            return constraint;
        }
        Constraint newConstraint = this.getSubstitutionConstraint(constraint, substitutionValueList);
        context.isTransformed = true;
        return newConstraint;
    }

    private boolean isSupportedComparator(Comparator comparator) {
        switch (comparator) {
            case EQUALS: 
            case NOT_EQUALS: 
            case GREATER: 
            case GREATER_OR_EQUALS: 
            case SMALLER: 
            case SMALLER_OR_EQUALS: {
                return true;
            }
        }
        return false;
    }

    private Constraint getSubstitutionConstraint(PropertyConstraint origConstraint, List<String> valueSubstitutes) {
        int substitutionSize = valueSubstitutes.size();
        if (substitutionSize == 1) {
            PropertyConstraint newConstraint = this.copyPropertyConstraintWith(origConstraint, valueSubstitutes.get(0));
            return newConstraint;
        }
        Constraint[] nestedConstraints = new PropertyConstraint[substitutionSize];
        for (int i = 0; i < substitutionSize; ++i) {
            String newComparableValue = valueSubstitutes.get(i);
            nestedConstraints[i] = this.copyPropertyConstraintWith(origConstraint, newComparableValue);
        }
        return QueryUtil.combineIntoSingleConstraint(nestedConstraints, Conjoiner.OR);
    }

    private PropertyConstraint copyPropertyConstraintWith(PropertyConstraint origConstraint, String newComparableValue) {
        PropertyConstraint newPropertyConstraint = new PropertyConstraint();
        newPropertyConstraint.targetType = origConstraint.targetType;
        newPropertyConstraint.propertyName = origConstraint.propertyName;
        newPropertyConstraint.comparator = origConstraint.comparator;
        newPropertyConstraint.comparableValue = newComparableValue;
        return newPropertyConstraint;
    }

    private static class TransformationContext {
        public boolean isTransformed = false;

        private TransformationContext() {
        }
    }
}

