/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.transform.impl;

import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.ResourceSpec;
import com.vmware.vise.data.query.FacetSpec;
import com.vmware.vise.data.query.OrderingCriteria;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.data.query.impl.ConstraintTree;
import com.vmware.vise.data.query.transform.TransformUtil;
import com.vmware.vise.data.query.transform.TransformationException;
import com.vmware.vise.data.query.transform.Transformer;
import com.vmware.vise.data.query.transform.TreeTransformer;
import com.vmware.vise.data.query.transform.impl.DataTransformerImpl;
import com.vmware.vise.data.query.transform.impl.PropertyValueSubstitutionTransformer;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.collection.Node;
import com.vmware.vise.util.collection.Tree;
import java.util.LinkedHashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class QuerySpecTransformer
implements Transformer<QuerySpec, QuerySpec> {
    private final Logger _logger = LoggerFactory.getLogger(DataTransformerImpl.class);
    private final PropertyValueSubstitutionTransformer _propertyValueSubstitutionTransformer = new PropertyValueSubstitutionTransformer();
    private final Set<Transformer<Constraint, Constraint>> _constraintTransformers = new LinkedHashSet<Transformer<Constraint, Constraint>>();
    private final Set<Transformer<PropertySpec, PropertySpec>> _propertySpecTransformers = new LinkedHashSet<Transformer<PropertySpec, PropertySpec>>();
    private final Set<Transformer<OrderingCriteria, OrderingCriteria>> _orderingCriteriaTransformers = new LinkedHashSet<Transformer<OrderingCriteria, OrderingCriteria>>();

    public void registerConstraintTransformer(Transformer<Constraint, Constraint> transformer) {
        this._constraintTransformers.add(transformer);
    }

    public void unregisterConstraintTransformer(Transformer<Constraint, Constraint> transformer) {
        this._constraintTransformers.remove(transformer);
    }

    public void registerPropertySpecTransformer(Transformer<PropertySpec, PropertySpec> transformer) {
        this._propertySpecTransformers.add(transformer);
    }

    public void unregisterPropertySpecTransformer(Transformer<PropertySpec, PropertySpec> transformer) {
        this._propertySpecTransformers.remove(transformer);
    }

    public void registerOrderingTransformer(Transformer<OrderingCriteria, OrderingCriteria> transformer) {
        this._orderingCriteriaTransformers.add(transformer);
    }

    public void unregisterOrderingTransformer(Transformer<OrderingCriteria, OrderingCriteria> transformer) {
        this._orderingCriteriaTransformers.remove(transformer);
    }

    @Override
    public Transformer.Result<QuerySpec> transform(QuerySpec querySpec) {
        try {
            QuerySpec clonedQuery = querySpec.clone();
            ResourceSpecTransformer resourceSpecTransformer = new ResourceSpecTransformer();
            Transformer.Result modifiedResourceSpecResult = resourceSpecTransformer.transform(clonedQuery.resourceSpec);
            ResultSpecTransformer resultSpecTransformer = new ResultSpecTransformer();
            Transformer.Result modifiedResultSpecResult = resultSpecTransformer.transform(clonedQuery.resultSpec);
            boolean modificationMade = modifiedResourceSpecResult.isTransformed() || modifiedResultSpecResult.isTransformed();
            TransformationException error = TransformUtil.getCompositeError(modifiedResourceSpecResult.getError(), modifiedResultSpecResult.getError());
            QuerySpec modifiedQuerySpec = querySpec;
            if (modificationMade) {
                ResourceSpec modifiedResourceSpec = (ResourceSpec)modifiedResourceSpecResult.getData();
                modifiedQuerySpec = new QuerySpec(clonedQuery);
                modifiedQuerySpec.name = "transformed-" + clonedQuery.name;
                modifiedQuerySpec.resourceSpec = modifiedResourceSpec;
                modifiedQuerySpec.resultSpec = (ResultSpec)modifiedResultSpecResult.getData();
            }
            return new Transformer.Result<QuerySpec>(modifiedQuerySpec, modificationMade, error);
        }
        catch (CloneNotSupportedException cnse) {
            this._logger.warn("Error has occurred while transforming query: " + querySpec.name, (Throwable)cnse);
            return new Transformer.Result<QuerySpec>(querySpec);
        }
    }

    public class ResultSpecTransformer
    implements Transformer<ResultSpec, ResultSpec> {
        @Override
        public Transformer.Result<ResultSpec> transform(ResultSpec resultSpec) {
            if (resultSpec == null) {
                return new Transformer.Result<Object>(null, false);
            }
            Transformer.Result<OrderingCriteria> modifiedOrderCriteriaResult = TransformUtil.executeTransformers(QuerySpecTransformer.this._orderingCriteriaTransformers, resultSpec.order);
            Transformer.Result<FacetSpec[]> modifiedFacetResult = this.transformFacetSpecs(resultSpec.facets);
            ResultSpec modifiedResultSpec = resultSpec;
            boolean modificationMade = modifiedOrderCriteriaResult.isTransformed() || modifiedFacetResult.isTransformed();
            TransformationException error = TransformUtil.getCompositeError(modifiedOrderCriteriaResult.getError(), modifiedFacetResult.getError());
            if (modificationMade) {
                modifiedResultSpec = new ResultSpec();
                modifiedResultSpec.offset = resultSpec.offset;
                modifiedResultSpec.maxResultCount = resultSpec.maxResultCount;
                modifiedResultSpec.order = modifiedOrderCriteriaResult.getData();
                modifiedResultSpec.facets = modifiedFacetResult.getData();
            }
            return new Transformer.Result<ResultSpec>(modifiedResultSpec, modificationMade, error);
        }

        private Transformer.Result<FacetSpec[]> transformFacetSpecs(FacetSpec[] origFacetSpecs) {
            FacetSpec[] modifiedFacetSpecs = null;
            boolean isModified = false;
            TransformationException facetTransError = null;
            if (origFacetSpecs != null && origFacetSpecs.length > 0) {
                modifiedFacetSpecs = new FacetSpec[origFacetSpecs.length];
                for (int i = 0; i < origFacetSpecs.length; ++i) {
                    Transformer.Result<PropertySpec> modifiedPropertyResult = TransformUtil.executeTransformers(QuerySpecTransformer.this._propertySpecTransformers, origFacetSpecs[i].propSpec);
                    facetTransError = TransformUtil.getCompositeError(facetTransError, modifiedPropertyResult.getError());
                    if (modifiedPropertyResult.isTransformed()) {
                        FacetSpec newFacetSpec = new FacetSpec();
                        newFacetSpec.propSpec = modifiedPropertyResult.getData();
                        modifiedFacetSpecs[i] = newFacetSpec;
                        isModified = true;
                        continue;
                    }
                    modifiedFacetSpecs[i] = origFacetSpecs[i];
                }
            }
            if (!isModified) {
                modifiedFacetSpecs = origFacetSpecs;
            }
            return new Transformer.Result<FacetSpec[]>(modifiedFacetSpecs, isModified, facetTransError);
        }
    }

    public class ResourceSpecTransformer
    implements Transformer<ResourceSpec, ResourceSpec> {
        @Override
        public Transformer.Result<ResourceSpec> transform(ResourceSpec resourceSpec) {
            boolean transformationMade;
            if (resourceSpec == null || resourceSpec.constraint == null) {
                throw new IllegalArgumentException("Invalid input query.");
            }
            Transformer.Result<Constraint> modifiedConstraintResult = this.transformConstraint(resourceSpec.constraint);
            Transformer.Result<PropertySpec[]> modifiedPropsResult = this.transformPropertySpecs(resourceSpec.propertySpecs);
            ResourceSpec modifiedResourceSpec = resourceSpec;
            TransformationException transformationError = TransformUtil.getCompositeError(modifiedConstraintResult.getError(), modifiedPropsResult.getError());
            boolean bl = transformationMade = modifiedConstraintResult.isTransformed() || modifiedPropsResult.isTransformed();
            if (transformationMade) {
                modifiedResourceSpec = new ResourceSpec();
                modifiedResourceSpec.constraint = modifiedConstraintResult.getData();
                modifiedResourceSpec.propertySpecs = modifiedPropsResult.getData();
            }
            return new Transformer.Result<ResourceSpec>(modifiedResourceSpec, transformationMade, transformationError);
        }

        private Transformer.Result<Constraint> transformConstraint(Constraint constraint) {
            if (constraint == null) {
                return new Transformer.Result<Object>(null);
            }
            Transformer.Result<Tree<Constraint>> nodeTransformationResult = this.executePerNodeTransformers(constraint);
            Constraint nodeTransformedConstraint = (Constraint)nodeTransformationResult.getData().getRoot().getData();
            Transformer.Result<Constraint> treeTransformationResult = this.executePerTreeTransformers(nodeTransformedConstraint);
            boolean transformationMade = nodeTransformationResult.isTransformed() || treeTransformationResult.isTransformed();
            TransformationException transformationError = TransformUtil.getCompositeError(nodeTransformationResult.getError(), treeTransformationResult.getError());
            return new Transformer.Result<Constraint>(treeTransformationResult.getData(), transformationMade, transformationError);
        }

        private Transformer.Result<Constraint> executePerTreeTransformers(Constraint constraint) {
            return QuerySpecTransformer.this._propertyValueSubstitutionTransformer.transform(constraint);
        }

        private Transformer.Result<Tree<Constraint>> executePerNodeTransformers(Constraint constraint) {
            ConstraintTree constraintTree = new ConstraintTree(constraint);
            Transformer<Node<Constraint>, Node<Constraint>> treeNodeTransformer = new Transformer<Node<Constraint>, Node<Constraint>>(){

                @Override
                public Transformer.Result<Node<Constraint>> transform(Node<Constraint> node) {
                    Transformer.Result<Object> transformedConstraintResult = TransformUtil.executeTransformers(QuerySpecTransformer.this._constraintTransformers, node.getData());
                    Constraint transformedConstraint = (Constraint)transformedConstraintResult.getData();
                    ConstraintTree.ConstraintNode transformedNode = new ConstraintTree.ConstraintNode(transformedConstraint);
                    return new Transformer.Result<Node<Constraint>>(transformedNode, transformedConstraintResult.isTransformed(), transformedConstraintResult.getError());
                }
            };
            TreeTransformer<Constraint> constraintTransformer = new TreeTransformer<Constraint>(treeNodeTransformer);
            Transformer.Result<Tree<Constraint>> modifiedConstraintTreeResult = constraintTransformer.transform(constraintTree);
            return modifiedConstraintTreeResult;
        }

        private Transformer.Result<PropertySpec[]> transformPropertySpecs(PropertySpec[] origPropSpecs) {
            PropertySpec[] modifiedPropSpecs = null;
            TransformationException propertyTransError = null;
            boolean isModified = false;
            if (!ArrayUtil.isNullOrEmpty((Object[])origPropSpecs)) {
                modifiedPropSpecs = new PropertySpec[origPropSpecs.length];
                for (int i = 0; i < origPropSpecs.length; ++i) {
                    Transformer.Result<PropertySpec> modifiedPropertyResult = TransformUtil.executeTransformers(QuerySpecTransformer.this._propertySpecTransformers, origPropSpecs[i]);
                    propertyTransError = TransformUtil.getCompositeError(propertyTransError, modifiedPropertyResult.getError());
                    if (modifiedPropertyResult.isTransformed()) {
                        modifiedPropSpecs[i] = modifiedPropertyResult.getData();
                        isModified = true;
                        continue;
                    }
                    modifiedPropSpecs[i] = origPropSpecs[i];
                }
            }
            if (!isModified) {
                modifiedPropSpecs = origPropSpecs;
            }
            return new Transformer.Result<PropertySpec[]>(modifiedPropSpecs, isModified, propertyTransError);
        }
    }
}

