/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.traverser;

import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.RelationalConstraint;

public abstract class ConstraintNoResultTraverser {
    protected void traverseConstraint(Constraint constraint) {
        if (constraint instanceof ObjectIdentityConstraint) {
            ObjectIdentityConstraint oic = (ObjectIdentityConstraint)constraint;
            this.traverseObjectIdentityConstraint(oic);
        } else if (constraint instanceof PropertyConstraint) {
            PropertyConstraint propertyConstraint = (PropertyConstraint)constraint;
            this.traversePropertyConstraint(propertyConstraint);
        } else if (constraint instanceof RelationalConstraint) {
            RelationalConstraint relationalConstraint = (RelationalConstraint)constraint;
            this.traverseRelationalConstraint(relationalConstraint);
        } else if (constraint instanceof CompositeConstraint) {
            CompositeConstraint compositeConstraint = (CompositeConstraint)constraint;
            this.traverseCompositeConstraint(compositeConstraint);
        }
    }

    protected abstract void traverseObjectIdentityConstraint(ObjectIdentityConstraint var1);

    protected abstract void traversePropertyConstraint(PropertyConstraint var1);

    protected void traverseRelationalConstraint(RelationalConstraint constraint) {
        this.traverseConstraint(constraint.constraintOnRelatedObject);
    }

    protected void traverseCompositeConstraint(CompositeConstraint constraint) {
        if (constraint.nestedConstraints == null) {
            return;
        }
        for (Constraint nestedConstraint : constraint.nestedConstraints) {
            this.traverseConstraint(nestedConstraint);
        }
    }
}

