/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.uri;

import com.vmware.vise.data.uri.ResourceTypeResolver;
import com.vmware.vise.data.uri.ResourceTypeResolverRegistry;
import com.vmware.vise.util.Pair;
import com.vmware.vise.util.StringUtil;
import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class InventoryServiceResourceTypeResolver
implements ResourceTypeResolver {
    public static final String PREFIX = "urn";
    public static final String VMODL2_URN_NAMSPACE = "vapi";
    private static final Log _logger = LogFactory.getLog(InventoryServiceResourceTypeResolver.class);
    private static final String UID_REGEX = "urn(:[^:#]++){4,}+(#[^:#]+)??";
    private static final String VMODL2_UID_REGEX = "urn:vapi:([^:]+):.+";
    private static final Pattern VMODL2_PATTERN = Pattern.compile("urn:vapi:([^:]+):.+");

    public static InventoryServiceResourceTypeResolver getResolver(ResourceTypeResolverRegistry resourceTypeRegistry) {
        InventoryServiceResourceTypeResolver inventoryServiceResolver = new InventoryServiceResourceTypeResolver();
        resourceTypeRegistry.registerSchemeResolver(PREFIX, inventoryServiceResolver);
        return inventoryServiceResolver;
    }

    @Override
    public String getServerGuid(URI uri) {
        Pair uriParts;
        String uriString = uri.toString();
        Matcher vmodl2Matcher = VMODL2_PATTERN.matcher(uriString);
        if (vmodl2Matcher.matches()) {
            return null;
        }
        if (!uriString.matches(UID_REGEX)) {
            _logger.warn((Object)("Uid does not match regex pattern: " + uriString));
            return null;
        }
        if (uriString.indexOf(35) != -1) {
            uriParts = StringUtil.removeLastWord((String)uriString, (char)'#');
            uriString = (String)uriParts.first;
        }
        uriParts = StringUtil.removeLastWord((String)uriString, (char)':');
        String serverGuid = (String)uriParts.second;
        return serverGuid;
    }

    @Override
    public String getResourceType(URI uri) {
        String uriString = uri.toString();
        Matcher vmodl2Matcher = VMODL2_PATTERN.matcher(uriString);
        if (vmodl2Matcher.matches()) {
            String resourceType = vmodl2Matcher.group(1);
            return resourceType;
        }
        if (!uriString.matches(UID_REGEX)) {
            _logger.warn((Object)("Uid does not match regex pattern: " + uriString));
            return null;
        }
        int typeNameIndex = uriString.indexOf(58, PREFIX.length() + 1);
        String uriSubstring = uriString.substring(typeNameIndex + 1);
        Pair uriParts = StringUtil.removeLastWord((String)uriSubstring, (char)':');
        uriParts = StringUtil.removeLastWord((String)((String)uriParts.first), (char)':');
        String typeName = (String)uriParts.first;
        return typeName;
    }
}

