/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.uri;

import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.ResourceObjectReferenceAdapter;
import com.vmware.vise.data.uri.ResourceTypeResolver;
import com.vmware.vise.data.uri.ResourceTypeResolverRegistry;
import com.vmware.vise.util.ValidationUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class UriRefTypeAdapter
implements ResourceObjectReferenceAdapter,
ResourceTypeResolverRegistry {
    private final ConcurrentMap<String, ResourceTypeResolver> _resolverByPrefix = new ConcurrentHashMap<String, ResourceTypeResolver>();

    public static UriRefTypeAdapter getUriRefTypeAdapter(DataServiceExtensionRegistry dataServiceExtensionRegistry) {
        UriRefTypeAdapter uriRefTypeAdapter = new UriRefTypeAdapter();
        if (dataServiceExtensionRegistry != null) {
            dataServiceExtensionRegistry.registerObjectRefTypeAdapter(uriRefTypeAdapter, URI.class, "urn:vri");
            dataServiceExtensionRegistry.registerObjectRefTypeAdapter(uriRefTypeAdapter, URI.class, "urn");
        }
        return uriRefTypeAdapter;
    }

    @Override
    public void registerSchemeResolver(String scheme, ResourceTypeResolver resolver) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{scheme, resolver});
        ResourceTypeResolver prevResolver = this._resolverByPrefix.putIfAbsent(scheme, resolver);
        if (prevResolver != null) {
            throw new UnsupportedOperationException("Cannot register more than one ResourceTypeResolver per URI scheme.");
        }
    }

    @Override
    public void unregisterSchemeResolver(String scheme) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{scheme});
        this._resolverByPrefix.remove(scheme);
    }

    @Override
    public Object getReference(String uid) {
        URI uri;
        try {
            uri = new URI(uid);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid URI provided.", e);
        }
        return uri;
    }

    @Override
    public String getServerGuid(Object reference) {
        URI uri = UriRefTypeAdapter.toURI(reference);
        String matchingPrefix = this.findUidPrefix(uri.toString());
        ResourceTypeResolver resolver = (ResourceTypeResolver)this._resolverByPrefix.get(matchingPrefix);
        if (resolver == null) {
            return null;
        }
        String serverGuid = resolver.getServerGuid(uri);
        return serverGuid;
    }

    @Override
    public String getResourceType(Object reference) {
        URI uri = UriRefTypeAdapter.toURI(reference);
        String matchingPrefix = this.findUidPrefix(uri.toString());
        ResourceTypeResolver resolver = (ResourceTypeResolver)this._resolverByPrefix.get(matchingPrefix);
        if (resolver == null) {
            return null;
        }
        String type2 = resolver.getResourceType(uri);
        return type2;
    }

    @Override
    public String getUid(Object reference) {
        URI uri = UriRefTypeAdapter.toURI(reference);
        String uriStr = uri.toString();
        return uriStr;
    }

    private static URI toURI(Object reference) {
        if (!(reference instanceof URI)) {
            throw new IllegalArgumentException("Reference of invalid type provided. Expected " + URI.class.getName());
        }
        URI uriRef = (URI)reference;
        return uriRef;
    }

    private String findUidPrefix(String uid) {
        assert (uid != null);
        String longestMatchingPrefix = "";
        for (String prefix : this._resolverByPrefix.keySet()) {
            String scheme = prefix + ":";
            if (!uid.startsWith(scheme) || prefix.length() <= longestMatchingPrefix.length()) continue;
            longestMatchingPrefix = prefix;
        }
        return longestMatchingPrefix;
    }
}

