/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.metadata;

import com.vmware.vise.core.model.data;
import com.vmware.vise.data.common.NameValuePair;
import com.vmware.vise.metadata.Descriptor;
import java.util.Arrays;
import java.util.Map;
import javax.xml.bind.annotation.XmlAttribute;

@data
public class TypeDescriptor
extends Descriptor {
    @XmlAttribute
    public Boolean immutable;
    public NameValuePair[] mutationArguments;
    public String supertype;

    public TypeDescriptor() {
    }

    public TypeDescriptor(String name, String title, String description, String superType, Map<String, String> tags, Boolean immutable, NameValuePair[] mutationArguments) {
        super(name, title, description, tags);
        this.immutable = immutable;
        this.supertype = superType;
        this.mutationArguments = mutationArguments;
    }

    public TypeDescriptor(TypeDescriptor original) {
        original.copyFieldsTo(this, false);
    }

    @Override
    protected void copyFieldsTo(Descriptor target, boolean cloneLocalizableFields) {
        super.copyFieldsTo(target, cloneLocalizableFields);
        if (target instanceof TypeDescriptor) {
            TypeDescriptor td = (TypeDescriptor)target;
            td.immutable = this.immutable;
            td.mutationArguments = this.mutationArguments;
            td.supertype = this.supertype;
        }
    }

    @Override
    protected void appendFieldValuesTo(StringBuilder sb) {
        super.appendFieldValuesTo(sb);
        sb.append(", immutable=").append(this.immutable).append(", mutationArguments=").append(Arrays.toString(this.mutationArguments)).append(", superType=").append(this.supertype);
    }
}

