/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.metadata;

import com.vmware.vise.core.model.data;
import com.vmware.vise.metadata.Descriptor;
import com.vmware.vise.metadata.PropertyNodeDescriptor;
import com.vmware.vise.metadata.TypeDescriptor;
import com.vmware.vise.util.i18n.MessageLocalizer;

@data
public class TypeNodeDescriptor
extends TypeDescriptor {
    public PropertyNodeDescriptor[] properties;

    public TypeNodeDescriptor() {
    }

    public TypeNodeDescriptor(TypeDescriptor original) {
        super(original);
    }

    public TypeNodeDescriptor(TypeNodeDescriptor original) {
        original.copyFieldsTo(this, false);
    }

    public static TypeNodeDescriptor createArrayDescriptor(TypeNodeDescriptor[] types) {
        TypeNodeDescriptor arrayDescriptor = new TypeNodeDescriptor();
        arrayDescriptor.name = "array";
        arrayDescriptor.properties = new PropertyNodeDescriptor[types.length];
        for (int i = 0; i < types.length; ++i) {
            PropertyNodeDescriptor property = new PropertyNodeDescriptor();
            property.name = Integer.toString(i);
            property.valueType = types[i];
            arrayDescriptor.properties[i] = property;
        }
        return arrayDescriptor;
    }

    @Override
    protected void copyFieldsTo(Descriptor target, boolean cloneLocalizableFields) {
        super.copyFieldsTo(target, cloneLocalizableFields);
        if (target instanceof TypeNodeDescriptor) {
            TypeNodeDescriptor tnd = (TypeNodeDescriptor)target;
            if (cloneLocalizableFields && this.properties != null) {
                int numProps = this.properties.length;
                tnd.properties = new PropertyNodeDescriptor[numProps];
                for (int i = 0; i < numProps; ++i) {
                    PropertyNodeDescriptor pnd = this.properties[i];
                    if (pnd == null) continue;
                    tnd.properties[i] = new PropertyNodeDescriptor();
                    pnd.copyFieldsTo(tnd.properties[i], true);
                }
            } else {
                tnd.properties = this.properties;
            }
        }
    }

    @Override
    protected void localize(MessageLocalizer msgLoc) {
        super.localize(msgLoc);
        if (msgLoc == null) {
            return;
        }
        if (this.properties != null) {
            for (PropertyNodeDescriptor pnd : this.properties) {
                pnd.localize(msgLoc);
            }
        }
    }
}

