/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.metadata.impl;

import com.vmware.vise.metadata.impl.BundleMetadata;
import com.vmware.vise.util.ExceptionUtil;
import java.io.IOException;
import java.net.URL;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.ValidationEventLocator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;

public class BundleMetadataDeserializer {
    private static final Log _logger = LogFactory.getLog(BundleMetadataDeserializer.class);
    private static final String METADATA_FILE_NAME = "resource-info.xml";

    public static BundleMetadata getBundleMetadata(Bundle bundle) {
        BundleMetadata metadata = new BundleMetadata();
        try {
            URL metadataUrl = bundle.getEntry(METADATA_FILE_NAME);
            if (metadataUrl == null) {
                return null;
            }
            JAXBContext jaxbContext = JAXBContextHolder.INSTANCE;
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            unmarshaller.setEventHandler((ValidationEventHandler)new LoggingJaxbValidationEventHandler(bundle));
            metadata = (BundleMetadata)unmarshaller.unmarshal(metadataUrl.openStream());
        }
        catch (JAXBException e) {
            _logger.error((Object)e);
        }
        catch (IOException e) {
            _logger.error((Object)e);
        }
        return metadata;
    }

    static class LoggingJaxbValidationEventHandler
    implements ValidationEventHandler {
        private static final Log _logger = LogFactory.getLog(LoggingJaxbValidationEventHandler.class);
        private final Bundle _bundle;

        public LoggingJaxbValidationEventHandler(Bundle bundle) {
            if (bundle == null) {
                throw new IllegalArgumentException("The bundle shouldn't be null");
            }
            this._bundle = bundle;
        }

        public boolean handleEvent(ValidationEvent event) {
            int severity = event.getSeverity();
            String msg = this.buildMessage(event);
            if (severity == 0) {
                _logger.warn((Object)msg);
            } else {
                _logger.error((Object)msg);
            }
            return true;
        }

        private String buildMessage(ValidationEvent event) {
            StringBuilder msg = new StringBuilder(200);
            ValidationEventLocator locator = event.getLocator();
            if (locator.getLineNumber() >= 0) {
                msg.append("Line ").append(locator.getLineNumber());
            }
            if (locator.getColumnNumber() >= 0) {
                if (msg.length() > 0) {
                    msg.append(", ");
                }
                msg.append("Column ").append(locator.getColumnNumber());
            }
            if (msg.length() > 0) {
                msg.append(": ");
            }
            msg.append("Problem while parsing the metadata in bundle ").append(this._bundle.getSymbolicName());
            URL xmlSourceUrl = locator.getURL();
            if (xmlSourceUrl != null) {
                msg.append(" from URL ").append(xmlSourceUrl);
            }
            msg.append(": ").append(event.getMessage());
            Throwable linkedException = event.getLinkedException();
            if (linkedException != null) {
                String stackTrace = ExceptionUtil.getStackTrace((Throwable)linkedException);
                msg.append("\nLinked exception: ").append(stackTrace);
            }
            return msg.toString();
        }
    }

    private static class JAXBContextHolder {
        public static final JAXBContext INSTANCE;

        private JAXBContextHolder() {
        }

        static {
            try {
                INSTANCE = JAXBContext.newInstance((Class[])new Class[]{BundleMetadata.class});
            }
            catch (JAXBException e) {
                throw new ExceptionInInitializerError(e);
            }
        }
    }
}

