/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.metadata.impl;

import com.vmware.vise.metadata.ResourceUtilMessageLocalizer;
import com.vmware.vise.metadata.TypeDescriptor;
import com.vmware.vise.metadata.impl.BundleMetadata;
import com.vmware.vise.metadata.impl.MetadataServiceRegistryInternal;
import com.vmware.vise.metadata.impl.TypeDescriptorEx;
import com.vmware.vise.util.i18n.MessageLocalizer;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BundleMetadataRegistrar {
    private static final Log _logger = LogFactory.getLog(BundleMetadataRegistrar.class);
    public static MetadataServiceRegistryInternal metadataRegistry;
    private final String _resourceInfoFilename;
    private final String _resourceInfoMessagesFilename;

    public BundleMetadataRegistrar(String resourceInfoFilename) {
        this(resourceInfoFilename, null);
    }

    public BundleMetadataRegistrar(String resourceInfoFilename, String resourceInfoMessagesFilename) {
        this(resourceInfoFilename, resourceInfoMessagesFilename, null);
    }

    public BundleMetadataRegistrar(String resourceInfoFilename, String resourceInfoMessagesFilename, ClassLoader classLoader) {
        this._resourceInfoFilename = resourceInfoFilename;
        this._resourceInfoMessagesFilename = resourceInfoMessagesFilename;
        this.registerMetadata(classLoader);
    }

    private void registerMetadata(ClassLoader classLoader) {
        BundleMetadata bundleMetadata;
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        if ((bundleMetadata = this.getBundleMetadata(classLoader)) == null) {
            return;
        }
        _logger.info((Object)("Metadata Service is registering the metadata found in file '" + this._resourceInfoFilename + "'"));
        ResourceUtilMessageLocalizer msgLoc = new ResourceUtilMessageLocalizer(classLoader, this._resourceInfoMessagesFilename);
        if (bundleMetadata.typeInfo != null) {
            this.processTypeInfo(bundleMetadata.typeInfo);
            metadataRegistry.registerTypeMetadata(bundleMetadata.typeInfo, (MessageLocalizer)msgLoc);
        }
        if (bundleMetadata.propertyInfo != null) {
            metadataRegistry.registerPropertyMetadata(bundleMetadata.propertyInfo, msgLoc);
        }
    }

    private void processTypeInfo(TypeDescriptorEx[] typeDescsEx) {
        for (TypeDescriptorEx tdx : typeDescsEx) {
            TypeDescriptor type2 = tdx.getTypeDescriptor();
            if (type2.tags == null) {
                type2.tags = new HashMap();
            }
            type2.tags.put("userSearchable", "false");
        }
    }

    private BundleMetadata getBundleMetadata(ClassLoader resourceClassLoader) {
        BundleMetadata metadata = new BundleMetadata();
        try (InputStream metadataStream = resourceClassLoader.getResourceAsStream(this._resourceInfoFilename);){
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Found metadata stream for: " + this._resourceInfoFilename));
            }
            JAXBContext jaxbContext = JAXBContextHolder.INSTANCE;
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            metadata = (BundleMetadata)unmarshaller.unmarshal(metadataStream);
        }
        catch (JAXBException e) {
            _logger.error((Object)"Error while reading the resource metadata.", (Throwable)e);
        }
        catch (IOException ioe) {
            _logger.error((Object)"Error while opening resource input stream.", (Throwable)ioe);
        }
        return metadata;
    }

    private static class JAXBContextHolder {
        public static final JAXBContext INSTANCE;

        private JAXBContextHolder() {
        }

        static {
            try {
                INSTANCE = JAXBContext.newInstance((Class[])new Class[]{BundleMetadata.class});
            }
            catch (JAXBException e) {
                throw new ExceptionInInitializerError(e);
            }
        }
    }
}

