/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.plugin.manifest.model.object;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.vmware.vise.plugin.manifest.model.PluginConfig;
import com.vmware.vise.plugin.manifest.model.object.ObjectType;
import com.vmware.vise.plugin.manifest.model.object.menu.Menu;
import com.vmware.vise.plugin.manifest.model.object.summary.Portlet;
import com.vmware.vise.plugin.manifest.model.object.summary.Summary;
import com.vmware.vise.plugin.manifest.model.object.view.Category;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.Validate;

public class ObjectScope {
    @JsonProperty(value="summary")
    public Summary summary;
    @JsonProperty(value="monitor")
    public Category monitorCategory;
    @JsonProperty(value="configure")
    public Category configureCategory;
    @JsonProperty(value="menu")
    public Menu menu;
    @JsonIgnore
    public ObjectType objectType;

    public final Summary getSummary() {
        return this.summary;
    }

    public final Category getMonitorCategory() {
        return this.monitorCategory;
    }

    public final Category getConfigureCategory() {
        return this.configureCategory;
    }

    public final Menu getMenu() {
        return this.menu;
    }

    public final ObjectType getObjectType() {
        return this.objectType;
    }

    public final void setObjectType(ObjectType objectType) {
        this.objectType = objectType;
    }

    @JsonIgnore
    public final List<Category> getCategories() {
        ArrayList<Category> categories = new ArrayList<Category>();
        if (this.monitorCategory != null) {
            categories.add(this.monitorCategory);
        }
        if (this.configureCategory != null) {
            categories.add(this.configureCategory);
        }
        return categories;
    }

    public final void setConfiguration(PluginConfig config) {
        Portlet portlet;
        Validate.notNull(config);
        Portlet portlet2 = portlet = this.summary != null ? this.summary.getPortlet() : null;
        if (portlet != null) {
            portlet.setTitleKey(config.getNameKey());
            portlet.setIcon(config.getIcon());
        }
        if (this.monitorCategory != null) {
            this.monitorCategory.setLabelKey(config.getNameKey());
        }
        if (this.configureCategory != null) {
            this.configureCategory.setLabelKey(config.getNameKey());
        }
        if (this.menu != null) {
            this.menu.setLabelKey(config.getNameKey());
            this.menu.setIcon(config.getIcon());
        }
    }
}

