/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo;

import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.FontState;
import org.apache.fop.layout.LineArea;
import org.apache.fop.layout.LinkSet;
import org.apache.fop.layout.TextState;

public class FOText
extends FONode {
    private char[] ca;
    private FontState fs;
    private float red;
    private float green;
    private float blue;
    private int wrapOption;
    private int whiteSpaceCollapse;
    private int verticalAlign;
    private TextState ts;

    public FOText(StringBuffer b, FObj parent) {
        super(parent);
        this.ca = new char[b.length()];
        b.getChars(0, b.length(), this.ca, 0);
    }

    protected static int addRealText(BlockArea ba, FontState fontState, float red, float green, float blue, int wrapOption, LinkSet ls, int whiteSpaceCollapse, char[] data2, int start, int end, TextState textState, int vAlign) {
        LineArea la = ba.getCurrentLineArea();
        if (la == null) {
            return start;
        }
        la.changeFont(fontState);
        la.changeColor(red, green, blue);
        la.changeWrapOption(wrapOption);
        la.changeWhiteSpaceCollapse(whiteSpaceCollapse);
        la.changeVerticalAlign(vAlign);
        ba.setupLinkSet(ls);
        start = la.addText(data2, start, end, ls, textState);
        while (start != -1) {
            la = ba.createNextLineArea();
            if (la == null) {
                return start;
            }
            la.changeFont(fontState);
            la.changeColor(red, green, blue);
            la.changeWrapOption(wrapOption);
            la.changeWhiteSpaceCollapse(whiteSpaceCollapse);
            ba.setupLinkSet(ls);
            start = la.addText(data2, start, end, ls, textState);
        }
        return -1;
    }

    public static int addText(BlockArea ba, FontState fontState, float red, float green, float blue, int wrapOption, LinkSet ls, int whiteSpaceCollapse, char[] data2, int start, int end, TextState textState, int vAlign) {
        if (fontState.getFontVariant() == 103) {
            FontState smallCapsFontState;
            try {
                int smallCapsFontHeight = (int)((double)fontState.getFontSize() * 0.8);
                smallCapsFontState = new FontState(fontState.getFontInfo(), fontState.getFontFamily(), fontState.getFontStyle(), fontState.getFontWeight(), smallCapsFontHeight, 76);
            }
            catch (FOPException fOPException) {
                smallCapsFontState = fontState;
            }
            char[] newdata = new char[end];
            int i = start;
            while (i < end) {
                FontState fontStateToUse;
                int index;
                int caseStart = i;
                char c = data2[i];
                boolean isLowerCase = Character.isLetter(c) && Character.isLowerCase(c);
                while (isLowerCase == (Character.isLetter(c) && Character.isLowerCase(c))) {
                    newdata[i] = isLowerCase ? Character.toUpperCase(c) : c;
                    if (++i == end) break;
                    c = data2[i];
                }
                if ((index = FOText.addRealText(ba, fontStateToUse = isLowerCase ? smallCapsFontState : fontState, red, green, blue, wrapOption, ls, whiteSpaceCollapse, newdata, caseStart, i, textState, vAlign)) == -1) continue;
                return index;
            }
            return -1;
        }
        return FOText.addRealText(ba, fontState, red, green, blue, wrapOption, ls, whiteSpaceCollapse, data2, start, end, textState, vAlign);
    }

    public int layout(Area area) throws FOPException {
        if (!(area instanceof BlockArea)) {
            this.log.error("text outside block area" + new String(this.ca, 0, this.ca.length));
            return 1;
        }
        if (this.marker == -1000) {
            String fontFamily = this.parent.properties.get("font-family").getString();
            String fontStyle = this.parent.properties.get("font-style").getString();
            String fontWeight = this.parent.properties.get("font-weight").getString();
            int fontSize = this.parent.properties.get("font-size").getLength().mvalue();
            int fontVariant = this.parent.properties.get("font-variant").getEnum();
            int letterSpacing = this.parent.properties.get("letter-spacing").getLength().mvalue();
            this.fs = new FontState(area.getFontInfo(), fontFamily, fontStyle, fontWeight, fontSize, fontVariant, letterSpacing);
            ColorType c = this.parent.properties.get("color").getColorType();
            this.red = c.red();
            this.green = c.green();
            this.blue = c.blue();
            this.verticalAlign = this.parent.properties.get("vertical-align").getEnum();
            this.wrapOption = this.parent.properties.get("wrap-option").getEnum();
            this.whiteSpaceCollapse = this.parent.properties.get("white-space-collapse").getEnum();
            this.marker = 0;
        }
        int orig_start = this.marker;
        this.marker = FOText.addText((BlockArea)area, this.fs, this.red, this.green, this.blue, this.wrapOption, this.getLinkSet(), this.whiteSpaceCollapse, this.ca, this.marker, this.ca.length, this.ts, this.verticalAlign);
        if (this.marker == -1) {
            return 1;
        }
        if (this.marker != orig_start) {
            return 3;
        }
        return 2;
    }

    public boolean mayPrecedeMarker() {
        int i = 0;
        while (i < this.ca.length) {
            char ch = this.ca[i];
            if (ch != ' ' || ch != '\n' || ch != '\r' || ch != '\t') {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setTextState(TextState ts) {
        this.ts = ts;
    }

    public boolean willCreateArea() {
        this.whiteSpaceCollapse = this.parent.properties.get("white-space-collapse").getEnum();
        if (this.whiteSpaceCollapse == 36 && this.ca.length > 0) {
            return true;
        }
        int i = 0;
        while (i < this.ca.length) {
            char ch = this.ca[i];
            if (ch != ' ' && ch != '\n' && ch != '\r' && ch != '\t') {
                return true;
            }
            ++i;
        }
        return false;
    }
}

