/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.fop.pdf.PDFFilter;

public class ASCII85Filter
extends PDFFilter {
    private static final char ASCII85_ZERO = 'z';
    private static final char ASCII85_START = '!';
    private static final String ASCII85_EOD = "~>";
    private static final long base85_4 = 85L;

    private byte[] convertWord(long word) {
        if ((word &= 0xFFFFFFFFFFFFFFFFL) < 0L) {
            word = -word;
        }
        if (word == 0L) {
            byte[] result = new byte[]{122};
            return result;
        }
        byte c5 = (byte)(word % 85L + 33L);
        byte c4 = (byte)((word /= 85L) % 85L + 33L);
        byte c3 = (byte)((word /= 85L) % 85L + 33L);
        byte c2 = (byte)((word /= 85L) % 85L + 33L);
        byte c1 = (byte)((word /= 85L) % 85L + 33L);
        byte[] ret = new byte[]{c1, c2, c3, c4, c5};
        int i = 0;
        while (i < ret.length) {
            if (ret[i] < 33 || ret[i] > 117) {
                System.out.println("illegal char value " + new Integer(ret[i]));
            }
            ++i;
        }
        return ret;
    }

    public byte[] encode(byte[] data2) {
        byte[] eod;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        boolean total = false;
        boolean diff = false;
        int i = 0;
        while (i + 3 < data2.length) {
            long val = ((long)(data2[i] << 24) & 0xFF000000L) + ((long)(data2[i + 1] << 16) & 0xFF0000L) + ((long)(data2[i + 2] << 8) & 0xFF00L) + ((long)data2[i + 3] & 0xFFL);
            byte[] conv = this.convertWord(val);
            buffer.write(conv, 0, conv.length);
            i += 4;
        }
        if (i < data2.length) {
            int n = data2.length - i;
            byte[] lastdata = new byte[4];
            int j = 0;
            while (j < 4) {
                lastdata[j] = j < n ? data2[i++] : (byte)0;
                ++j;
            }
            long val = ((long)(lastdata[0] << 24) & 0xFF000000L) + ((long)(lastdata[1] << 16) & 0xFF0000L) + ((long)(lastdata[2] << 8) & 0xFF00L) + ((long)lastdata[3] & 0xFFL);
            byte[] conv = this.convertWord(val);
            if (val == 0L) {
                conv = new byte[5];
                int j2 = 0;
                while (j2 < 5) {
                    conv[j2] = 33;
                    ++j2;
                }
            }
            buffer.write(conv, 0, n + 1);
        }
        try {
            eod = ASCII85_EOD.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            eod = ASCII85_EOD.getBytes();
        }
        buffer.write(eod, 0, eod.length);
        byte[] result = buffer.toByteArray();
        return result;
    }

    public String getDecodeParms() {
        return null;
    }

    public String getName() {
        return "/ASCII85Decode";
    }
}

