/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.ls.authz.impl;

import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.license.client.cis.ls.authz.AuthorizationException;
import com.vmware.license.client.cis.ls.authz.AuthorizationManager;
import com.vmware.license.client.cis.ls.scope.ScopeResolver;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.debug.TimeMonitor;
import com.vmware.vise.vim.security.LegacyAuthorizationService;
import java.util.concurrent.TimeUnit;

public class VpxAuthorizationManagerImpl
implements AuthorizationManager {
    private static final String VPX_LICENSE_ADMIN_PRIVILEGE_NAME = "Global.Licenses";
    private static final long AUTHZ_CALL_LOG_THRESHOLD_IN_NANOS = TimeUnit.SECONDS.toNanos(30L);
    private static final String VC_MO_VALUE = "group-d1";
    private static final String VC_MO_TYPE = "Folder";
    private final ScopeResolver _scopeResolver;
    private final LegacyAuthorizationService _authorizationService;

    public VpxAuthorizationManagerImpl(ScopeResolver scopeResolver, LegacyAuthorizationService authorizationService) {
        this._scopeResolver = scopeResolver;
        this._authorizationService = authorizationService;
    }

    @Override
    public boolean isLicensingAdminPrivilegeGranted(LicenseScope scope) throws AuthorizationException {
        ValidationUtil.paramsNotNull((Object[])new Object[]{scope});
        try {
            boolean result = this.isVpxLicenseAdminPrivilegeGranted(scope);
            return result;
        }
        catch (Exception e) {
            throw new AuthorizationException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isVpxLicenseAdminPrivilegeGranted(LicenseScope scope) throws Exception {
        String vcId = this._scopeResolver.getVcId(scope);
        ManagedObjectReference vcMoRef = this.buildVcMoRef(vcId);
        TimeMonitor timeMonitor = new TimeMonitor();
        try {
            timeMonitor.init();
            boolean bl = this._authorizationService.checkPrivileges(new ManagedObjectReference[]{vcMoRef}, new String[]{VPX_LICENSE_ADMIN_PRIVILEGE_NAME});
            return bl;
        }
        finally {
            timeMonitor.logTimeIfExceeding(AUTHZ_CALL_LOG_THRESHOLD_IN_NANOS, "NGC authorization service check privileges", LegacyAuthorizationService.class, (Object)this._authorizationService);
        }
    }

    private ManagedObjectReference buildVcMoRef(String vcId) {
        return new ManagedObjectReference(VC_MO_TYPE, VC_MO_VALUE, vcId);
    }
}

