/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.ls.impl;

import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.license.client.cis.ls.LsVmodlVersionSelector;
import com.vmware.license.client.cis.ls.scope.ScopeResolver;
import com.vmware.license.client.cis.ls.scope.ScopeResolverException;
import com.vmware.license.client.cis.ls.topology.SsoSpecificTopologyInfoProvider;
import com.vmware.license.client.cis.ls.topology.SsoSpecificTopologyInfoProviderFactory;
import com.vmware.license.client.cis.ls.topology.TopologyInfoRetrievalException;
import com.vmware.vim.binding.cis.license.version.dev;
import com.vmware.vim.binding.cis.license.version.version1;
import com.vmware.vim.binding.cis.license.version.version2;
import com.vmware.vise.util.Pair;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.Version;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LsVmodlVersionSelectorImpl
implements LsVmodlVersionSelector {
    private final Log _logger = LogFactory.getLog(LsVmodlVersionSelectorImpl.class);
    private static final List<Pair<Version, Class<?>>> lsVersionsToLsVmodlVersions = new ArrayList();
    private final SsoSpecificTopologyInfoProviderFactory _topologyInfoProviderFactory;
    private final ScopeResolver _scopeResolver;

    public LsVmodlVersionSelectorImpl(SsoSpecificTopologyInfoProviderFactory topologyInfoProviderFactory, ScopeResolver scopeResolver) {
        this._topologyInfoProviderFactory = topologyInfoProviderFactory;
        this._scopeResolver = scopeResolver;
    }

    @Override
    public Class<?> getLicenseServiceVmodlVersion(LicenseScope licenseScope) {
        Class lsVmodlVersion = version1.class;
        String lsVersion = null;
        try {
            String vcId = this._scopeResolver.getVcId(licenseScope);
            SsoSpecificTopologyInfoProvider ssoSpecificTopologyInfoProvider = this._topologyInfoProviderFactory.getTopologyInfoProviderForVc(vcId);
            if (ssoSpecificTopologyInfoProvider != null) {
                lsVersion = ssoSpecificTopologyInfoProvider.getLicenseServiceVersion();
            }
        }
        catch (TopologyInfoRetrievalException e) {
            this._logger.error((Object)("License service's version could not be retrieved! Defaulting to version1! Error: " + e));
        }
        catch (ScopeResolverException e) {
            this._logger.error((Object)("The scope for which the LS version has to be determined, can't be resolved! Error: " + e));
        }
        Version convertedLsVersion = this.convertLsVersionTextToVersion(lsVersion);
        if (convertedLsVersion != null) {
            for (Pair<Version, Class<?>> lsVersionToVmodlVersionPair : lsVersionsToLsVmodlVersions) {
                if (convertedLsVersion.compareTo((Version)lsVersionToVmodlVersionPair.first) < 0) break;
                lsVmodlVersion = (Class)lsVersionToVmodlVersionPair.second;
            }
        }
        return lsVmodlVersion;
    }

    private Version convertLsVersionTextToVersion(String lsVersion) {
        if (StringUtil.isNullOrEmpty((String)lsVersion)) {
            return null;
        }
        String versionFormattedLsVersion = lsVersion.concat(".0");
        return new Version(versionFormattedLsVersion);
    }

    static {
        lsVersionsToLsVmodlVersions.add(new Pair((Object)new Version("1.0.0.0"), version1.class));
        lsVersionsToLsVmodlVersions.add(new Pair((Object)new Version("6.5.0.0"), version2.class));
        lsVersionsToLsVmodlVersions.add(new Pair((Object)new Version("6.7.0.0"), dev.class));
    }
}

