/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.management.adapter;

import com.vmware.license.client.cis.adapter.BaseLicensingObjectsDataProviderAdapterImpl;
import com.vmware.license.client.cis.management.AssetSearchProperties;
import com.vmware.license.client.cis.management.AssetType;
import com.vmware.license.client.cis.management.ManagementEditor;
import com.vmware.license.client.cis.management.adapter.AssetPropertyProviderBean;
import com.vmware.license.client.cis.management.adapter.BasePropertyProviderBean;
import com.vmware.license.client.cis.management.ds.Asset;
import com.vmware.license.client.cis.management.util.AssetUtil;
import com.vmware.license.client.cis.management.util.UriUtil;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.ResultUtil;
import com.vmware.vise.util.ArrayUtil;
import java.net.URI;
import java.util.ArrayList;

@type(value="HostSystem,Folder,ClusterComputeResource,Asset")
public class ObjectNavigatorRelatedObjectsDataProviderAdapterImpl
extends BaseLicensingObjectsDataProviderAdapterImpl<Asset> {
    private static final String RELATION_VCS = "vcs";
    private static final String RELATION_HOSTS = "hosts";
    private static final String RELATION_CLUSTERS = "clusters";
    private static final String RELATION_SOLUTIONS = "solutions";
    private final ManagementEditor _managementEditor;

    private static URI getSingleTarget(Constraint constraint) {
        if (!(constraint instanceof ObjectIdentityConstraint)) {
            return null;
        }
        Object target = ((ObjectIdentityConstraint)constraint).target;
        return (URI)target;
    }

    private static AssetType getAssetType(String relation) {
        AssetType result = null;
        result = RELATION_VCS.equals(relation) ? AssetType.VC : (RELATION_HOSTS.equals(relation) ? AssetType.HOST : (RELATION_CLUSTERS.equals(relation) ? AssetType.CLUSTER : (RELATION_SOLUTIONS.equals(relation) ? AssetType.SOLUTION : AssetType.UNKNOWN)));
        return result;
    }

    private static ResultItem[] getRelatedManagedObjectRefsResultItems(Asset[] assets) {
        ArrayList<ResultItem> result = new ArrayList<ResultItem>();
        for (Asset asset : assets) {
            ManagedObjectReference moRef = asset.getRelatedManagedObjectRef();
            if (moRef == null) continue;
            ResultItem resultItem = new ResultItem();
            resultItem.resourceObject = moRef;
            result.add(resultItem);
        }
        return result.toArray(new ResultItem[result.size()]);
    }

    public ObjectNavigatorRelatedObjectsDataProviderAdapterImpl(ManagementEditor managementEditor) {
        this._managementEditor = managementEditor;
    }

    @Override
    protected ResultSet getResultSet(QuerySpec querySpec) {
        AssetSearchProperties searchProperties;
        Constraint constraint = querySpec.resourceSpec.constraint;
        if (!(constraint instanceof RelationalConstraint)) {
            return ResultUtil.newEmptyResultSet();
        }
        String relation = ((RelationalConstraint)constraint).relation;
        AssetType assetType = ObjectNavigatorRelatedObjectsDataProviderAdapterImpl.getAssetType(relation);
        if (AssetType.UNKNOWN.equals((Object)assetType)) {
            return ResultUtil.newEmptyResultSet();
        }
        Constraint relatedObjectConstraint = ((RelationalConstraint)constraint).constraintOnRelatedObject;
        URI uri = ObjectNavigatorRelatedObjectsDataProviderAdapterImpl.getSingleTarget(relatedObjectConstraint);
        if (uri == null) {
            return ResultUtil.newEmptyResultSet();
        }
        Asset[] assets = null;
        if (UriUtil.isProductUri(uri)) {
            searchProperties = AssetUtil.createAssetSearchProperties(assetType);
            assets = this._managementEditor.getAssetsForProduct(uri, searchProperties);
        } else if (UriUtil.isLicenseUri(uri)) {
            searchProperties = AssetUtil.createAssetSearchProperties(assetType);
            assets = this._managementEditor.getAssetsForLicense(uri, searchProperties);
        }
        if (ArrayUtil.isNullOrEmpty(assets)) {
            return ResultUtil.newEmptyResultSet();
        }
        ResultSet result = null;
        if (AssetType.SOLUTION.equals((Object)assetType)) {
            result = this.getResultSet(querySpec, assets);
            result.totalMatchedObjectCount = assets.length;
        } else {
            result = new ResultSet();
            result.items = ObjectNavigatorRelatedObjectsDataProviderAdapterImpl.getRelatedManagedObjectRefsResultItems(assets);
            result.totalMatchedObjectCount = result.items.length;
        }
        return result;
    }

    @Override
    protected BasePropertyProviderBean<Asset> getPropertyProvider() {
        return new AssetPropertyProviderBean();
    }

    @Override
    protected URI getUri(Asset object) {
        return object.getUri();
    }

    @Override
    protected String getProvidedType() {
        return "Asset";
    }
}

