/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.management.impl;

import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.license.client.cis.management.AssetSearchProperties;
import com.vmware.license.client.cis.management.AssetUpdateLicenseSpec;
import com.vmware.license.client.cis.management.AssetUpdateNewLicenseSpec;
import com.vmware.license.client.cis.management.LicenseSearchProperties;
import com.vmware.license.client.cis.management.ManagementObjectsFormatter;
import com.vmware.license.client.cis.management.VpxManagementEditor;
import com.vmware.license.client.cis.management.ds.Asset;
import com.vmware.license.client.cis.management.ds.License;
import com.vmware.license.client.cis.management.ds.ProductAggregation;
import com.vmware.license.client.cis.management.ds.results.AddSubscriptionLicensePreviewResult;
import com.vmware.license.client.cis.management.ds.specs.AddSubscriptionLicensePreviewSpec;
import com.vmware.license.client.cis.management.ds.specs.AddSubscriptionLicenseSpec;
import com.vmware.license.client.cis.management.ds.specs.LicenseCreateSpec;
import com.vmware.license.client.cis.management.ds.specs.LicensePreviewSpec;
import com.vmware.license.client.cis.management.ds.specs.LicenseUpdateSpec;
import com.vmware.vim.binding.cis.license.management.AssetSearchSpecByLicenseState;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.net.URI;

public class FormattingVpxManagementEditorWrapperImpl
implements VpxManagementEditor {
    private final VpxManagementEditor _vpxManagementEditor;
    private final ManagementObjectsFormatter _formatter;

    public FormattingVpxManagementEditorWrapperImpl(VpxManagementEditor vpxManagementEditor, ManagementObjectsFormatter managementObjectsFormatter) {
        this._vpxManagementEditor = vpxManagementEditor;
        this._formatter = managementObjectsFormatter;
    }

    @Override
    public License[] getLicenses(URI[] licenseUris, LicenseScope scope) {
        License[] licenses = this._vpxManagementEditor.getLicenses(licenseUris, scope);
        this._formatter.formatLicenses(licenses);
        return licenses;
    }

    @Override
    public License[] getLicenses(LicenseScope scope, LicenseSearchProperties properties) {
        License[] licenses = this._vpxManagementEditor.getLicenses(scope, properties);
        this._formatter.formatLicenses(licenses);
        return licenses;
    }

    @Override
    public License[] getLicensesForProduct(URI productUri, LicenseSearchProperties properties) {
        License[] licenses = this._vpxManagementEditor.getLicensesForProduct(productUri, properties);
        this._formatter.formatLicenses(licenses);
        return licenses;
    }

    @Override
    public ProductAggregation[] getProductAggregations(URI[] productUris, LicenseScope scope) {
        ProductAggregation[] productAggregations = this._vpxManagementEditor.getProductAggregations(productUris, scope);
        this._formatter.formatProductAggregations(productAggregations);
        return productAggregations;
    }

    @Override
    public ProductAggregation[] getProductAggregationsForLicense(URI licenseUri) {
        ProductAggregation[] productAggregations = this._vpxManagementEditor.getProductAggregationsForLicense(licenseUri);
        this._formatter.formatProductAggregations(productAggregations);
        return productAggregations;
    }

    @Override
    public Asset[] getAssets(URI[] assetUris, LicenseScope scope) {
        Asset[] assets = this._vpxManagementEditor.getAssets(assetUris, scope);
        this._formatter.formatAssets(assets);
        return assets;
    }

    @Override
    public Asset[] getAssetsByMoRefs(ManagedObjectReference[] managedObjectReferences, LicenseScope scope) {
        Asset[] assets = this._vpxManagementEditor.getAssetsByMoRefs(managedObjectReferences, scope);
        this._formatter.formatAssets(assets);
        return assets;
    }

    @Override
    public Asset[] getAssets(LicenseScope scope, AssetSearchProperties properties) {
        Asset[] assets = this._vpxManagementEditor.getAssets(scope, properties);
        this._formatter.formatAssets(assets);
        return assets;
    }

    @Override
    public Asset[] getAssetsByLicenseState(AssetSearchProperties properties, AssetSearchSpecByLicenseState.LicenseState licenseState) {
        Asset[] assets = this._vpxManagementEditor.getAssetsByLicenseState(properties, licenseState);
        this._formatter.formatAssets(assets);
        return assets;
    }

    @Override
    public Asset[] getAssetsForProduct(URI productUri, AssetSearchProperties properties) {
        Asset[] assets = this._vpxManagementEditor.getAssetsForProduct(productUri, properties);
        this._formatter.formatAssets(assets);
        return assets;
    }

    @Override
    public Asset[] getAssetsForLicense(URI licenseUri, AssetSearchProperties properties) {
        Asset[] assets = this._vpxManagementEditor.getAssetsForLicense(licenseUri, properties);
        this._formatter.formatAssets(assets);
        return assets;
    }

    @Override
    public URI[] addLicenses(LicenseCreateSpec[] createSpecs) {
        return this._vpxManagementEditor.addLicenses(createSpecs);
    }

    @Override
    public URI addSubscriptionLicense(AddSubscriptionLicenseSpec spec) {
        return this._vpxManagementEditor.addSubscriptionLicense(spec);
    }

    @Override
    public void updateLicenses(LicenseUpdateSpec[] updateSpecs) {
        this._vpxManagementEditor.updateLicenses(updateSpecs);
    }

    @Override
    public void removeLicenses(URI[] licenseUris) {
        this._vpxManagementEditor.removeLicenses(licenseUris);
    }

    @Override
    public License[] previewLicenses(LicensePreviewSpec[] previewSpecs) {
        License[] licenses = this._vpxManagementEditor.previewLicenses(previewSpecs);
        this._formatter.formatLicenses(licenses);
        return licenses;
    }

    @Override
    public AddSubscriptionLicensePreviewResult previewSubscriptionLicense(AddSubscriptionLicensePreviewSpec spec) {
        AddSubscriptionLicensePreviewResult result = this._vpxManagementEditor.previewSubscriptionLicense(spec);
        this._formatter.formatSubscriptionInfos(result.subscriptions);
        return result;
    }

    @Override
    public void updateAssetsLicense(AssetUpdateLicenseSpec[] updateSpecs) {
        this._vpxManagementEditor.updateAssetsLicense(updateSpecs);
    }

    @Override
    public void updateAssetsWithNewLicense(AssetUpdateNewLicenseSpec[] assetUpdateNewLicenseSpecs) {
        this._vpxManagementEditor.updateAssetsWithNewLicense(assetUpdateNewLicenseSpecs);
    }

    @Override
    public void unregisterAssets(URI[] assetUris) {
        this._vpxManagementEditor.unregisterAssets(assetUris);
    }
}

