/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.management.util;

import com.vmware.license.client.cis.management.ds.Asset;
import com.vmware.license.client.cis.management.ds.AssignLicenseUnsupportedFeatures;
import com.vmware.license.client.cis.management.ds.AssignLicenseUnsupportedLicenseFeatures;
import com.vmware.license.client.cis.management.ds.Feature;
import com.vmware.license.client.cis.management.ds.License;
import com.vmware.license.client.cis.management.ds.ProductCapability;
import com.vmware.license.client.cis.management.util.AssetUtil;
import com.vmware.vise.util.ArrayUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AssignLicenseUnsupportedFeaturesUtil {
    private static final String FEATURE_ID_DELIM = ":";
    private static final String[] FEATURES_WITH_LIMIT_TOKENS = new String[]{"serialuri", "ft"};

    public static AssignLicenseUnsupportedFeatures createAssignLicenseUnsupportedFeatures(Asset[] assets, License[] licenses) {
        if (ArrayUtil.isNullOrEmpty((Object[])assets) || ArrayUtil.isNullOrEmpty((Object[])licenses)) {
            return null;
        }
        HashMap<URI, AssignLicenseUnsupportedLicenseFeatures> licenseRefToUnsupportedFeatures = new HashMap<URI, AssignLicenseUnsupportedLicenseFeatures>();
        for (License license : licenses) {
            AssignLicenseUnsupportedLicenseFeatures unsupportedLicenseFeatures = AssignLicenseUnsupportedFeaturesUtil.getUnsupportedLicenseFeatures(assets, license);
            licenseRefToUnsupportedFeatures.put(license.getUri(), unsupportedLicenseFeatures);
        }
        AssignLicenseUnsupportedFeatures result = new AssignLicenseUnsupportedFeatures();
        result.setLicenseRefToUnsupportedFeatures(licenseRefToUnsupportedFeatures);
        return result;
    }

    private static AssignLicenseUnsupportedLicenseFeatures getUnsupportedLicenseFeatures(Asset[] assets, License license) {
        HashMap<URI, Feature[]> assetRefToUnsupportedFeaturesInUse = new HashMap<URI, Feature[]>();
        HashMap<URI, Feature[]> assetRefToUnsupportedAvailableFeatures = new HashMap<URI, Feature[]>();
        for (Asset asset : assets) {
            Feature[] oldAvailableFeatures;
            Feature[] unsupportedAvailableFeatures;
            License newLicense = license.getIsEvaluation() ? asset.getEvaluationLicense() : license;
            Feature[] newAvailableFeatures = AssignLicenseUnsupportedFeaturesUtil.getAssetAvailableFeaturesFromLicense(asset, newLicense);
            Feature[] unsupportedFeaturesInUse = AssignLicenseUnsupportedFeaturesUtil.getMissingSourceFeatures(asset.getFeaturesInUse(), newAvailableFeatures);
            if (!ArrayUtil.isNullOrEmpty((Object[])unsupportedFeaturesInUse)) {
                assetRefToUnsupportedFeaturesInUse.put(asset.getUri(), unsupportedFeaturesInUse);
            }
            if (ArrayUtil.isNullOrEmpty((Object[])(unsupportedAvailableFeatures = AssignLicenseUnsupportedFeaturesUtil.getMissingSourceFeatures(oldAvailableFeatures = AssignLicenseUnsupportedFeaturesUtil.getAssetAvailableFeatures(asset), newAvailableFeatures)))) continue;
            assetRefToUnsupportedAvailableFeatures.put(asset.getUri(), unsupportedAvailableFeatures);
        }
        return AssignLicenseUnsupportedFeaturesUtil.buildAssignLicenseUnsupportedLicenseFeatures(assetRefToUnsupportedFeaturesInUse, assetRefToUnsupportedAvailableFeatures);
    }

    private static Feature[] getAssetAvailableFeatures(Asset asset) {
        return AssignLicenseUnsupportedFeaturesUtil.getAssetAvailableFeaturesFromLicense(asset, asset.getLicense());
    }

    private static Feature[] getAssetAvailableFeaturesFromLicense(Asset asset, License license) {
        ProductCapability assetProductCapability = AssetUtil.getAssetProductCapabilityFromLicense(asset, license);
        if (assetProductCapability == null) {
            return new Feature[0];
        }
        return assetProductCapability.getFeatures();
    }

    private static Feature[] getMissingSourceFeatures(Feature[] sourceFeatures, Feature[] targetFeatures) {
        if (ArrayUtil.isNullOrEmpty((Object[])sourceFeatures)) {
            return new Feature[0];
        }
        ArrayList<Feature> result = new ArrayList<Feature>();
        Set<String> targetFeatureTokens = AssignLicenseUnsupportedFeaturesUtil.getFeatureTokens(targetFeatures);
        for (Feature feature : sourceFeatures) {
            if (!AssignLicenseUnsupportedFeaturesUtil.isFeatureMissing(targetFeatureTokens, feature.getId())) continue;
            result.add(feature);
        }
        return result.toArray(new Feature[result.size()]);
    }

    private static Set<String> getFeatureTokens(Feature[] features) {
        HashSet<String> resultFeatureTokens = new HashSet<String>();
        if (ArrayUtil.isNullOrEmpty((Object[])features)) {
            return resultFeatureTokens;
        }
        for (Feature feature : features) {
            String featureToken = AssignLicenseUnsupportedFeaturesUtil.getFeatureToken(feature.getId());
            resultFeatureTokens.add(featureToken);
        }
        return resultFeatureTokens;
    }

    private static String getFeatureToken(String featureId) {
        int featureIdDelimIndex = featureId.indexOf(FEATURE_ID_DELIM);
        String resultFeatureToken = featureIdDelimIndex == -1 ? featureId : featureId.substring(0, featureIdDelimIndex);
        return resultFeatureToken;
    }

    private static boolean isFeatureMissing(Set<String> featureTokens, String featureId) {
        if (AssignLicenseUnsupportedFeaturesUtil.isFeatureRestriction(featureId)) {
            return false;
        }
        String featureToken = AssignLicenseUnsupportedFeaturesUtil.getFeatureToken(featureId);
        return !featureTokens.contains(featureToken);
    }

    private static boolean isFeatureRestriction(String featureId) {
        if (featureId.indexOf(FEATURE_ID_DELIM) == -1) {
            return false;
        }
        String featureToken = AssignLicenseUnsupportedFeaturesUtil.getFeatureToken(featureId);
        return !AssignLicenseUnsupportedFeaturesUtil.isFeatureWithLimit(featureToken);
    }

    private static boolean isFeatureWithLimit(String featureToken) {
        for (String featureWithLimitToken : FEATURES_WITH_LIMIT_TOKENS) {
            if (!featureWithLimitToken.equals(featureToken)) continue;
            return true;
        }
        return false;
    }

    private static AssignLicenseUnsupportedLicenseFeatures buildAssignLicenseUnsupportedLicenseFeatures(Map<URI, Feature[]> assetRefToUnsupportedFeaturesInUse, Map<URI, Feature[]> assetRefToUnsupportedAvailableFeatures) {
        AssignLicenseUnsupportedLicenseFeatures result = new AssignLicenseUnsupportedLicenseFeatures();
        result.setAssetRefToUnsupportedFeaturesInUse(assetRefToUnsupportedFeaturesInUse);
        result.setAssetRefToUnsupportedAvailableFeatures(assetRefToUnsupportedAvailableFeatures);
        return result;
    }
}

