/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.management.util;

import com.vmware.license.client.cis.management.ds.License;
import com.vmware.license.client.cis.management.ds.SubscriptionEntitlementAccount;
import com.vmware.license.client.cis.management.ds.SubscriptionInfo;
import com.vmware.license.client.cis.management.ds.SubscriptionService;
import com.vmware.license.client.cis.management.ds.results.AddSubscriptionLicensePreviewResult;
import com.vmware.vim.binding.cis.license.LicenseInfo;
import com.vmware.vim.binding.cis.license.LicenseUtilization;
import com.vmware.vim.binding.cis.license.SubscriptionLicenseInfo;

public class SubscriptionLicensingUtil {
    public static boolean isSubscriptionLicensingEnabled() {
        return false;
    }

    public static boolean isSubscriptionLicense(License license) {
        if (license == null || !SubscriptionLicensingUtil.isSubscriptionLicensingEnabled()) {
            return false;
        }
        return license.getSubscriptionInfo() != null;
    }

    public static AddSubscriptionLicensePreviewResult buildAddSubscriptionLicensePreviewResult(LicenseInfo[] licenseInfos) {
        for (LicenseInfo licenseInfo : licenseInfos) {
            if (SubscriptionLicensingUtil.isSubscriptionLicenseInfo(licenseInfo)) continue;
            throw new IllegalArgumentException("The runtime type of the provided license infos is not SubscriptionLicenseInfo.");
        }
        AddSubscriptionLicensePreviewResult previewResult = new AddSubscriptionLicensePreviewResult();
        SubscriptionInfo[] subscriptionsInfo = new SubscriptionInfo[licenseInfos.length];
        for (int i = 0; i < licenseInfos.length; ++i) {
            SubscriptionLicenseInfo serviceSubscriptionLicenseInfo = (SubscriptionLicenseInfo)licenseInfos[i];
            SubscriptionEntitlementAccount entitlementAccount = SubscriptionLicensingUtil.buildSubscriptionEntitlementAccount(serviceSubscriptionLicenseInfo);
            SubscriptionService service = SubscriptionLicensingUtil.buildSubscriptionService(serviceSubscriptionLicenseInfo);
            subscriptionsInfo[i] = SubscriptionLicensingUtil.buildSubscriptionInfo(entitlementAccount, service);
        }
        previewResult.subscriptions = subscriptionsInfo;
        return previewResult;
    }

    public static com.vmware.license.client.cis.management.ds.SubscriptionLicenseInfo buildSubscriptionLicenseInfo(LicenseInfo licenseInfo) {
        if (!SubscriptionLicensingUtil.isSubscriptionLicenseInfo(licenseInfo)) {
            return null;
        }
        SubscriptionLicenseInfo serviceSubscriptionLicenseInfo = (SubscriptionLicenseInfo)licenseInfo;
        SubscriptionEntitlementAccount entitlementAccount = SubscriptionLicensingUtil.buildSubscriptionEntitlementAccount(serviceSubscriptionLicenseInfo);
        SubscriptionService service = SubscriptionLicensingUtil.buildSubscriptionService(serviceSubscriptionLicenseInfo);
        com.vmware.license.client.cis.management.ds.SubscriptionLicenseInfo resultSubscriptionLicenseInfo = new com.vmware.license.client.cis.management.ds.SubscriptionLicenseInfo();
        resultSubscriptionLicenseInfo.setUserName(serviceSubscriptionLicenseInfo.getUsername());
        resultSubscriptionLicenseInfo.setEntitlementAccount(entitlementAccount);
        resultSubscriptionLicenseInfo.setService(service);
        return resultSubscriptionLicenseInfo;
    }

    public static boolean isSubscriptionLicenseUtilization(LicenseUtilization licenseUtilization) {
        if (licenseUtilization == null) {
            return false;
        }
        return SubscriptionLicensingUtil.isSubscriptionLicenseInfo(licenseUtilization.getLicense().getInfo());
    }

    public static boolean isSubscriptionLicenseInfo(LicenseInfo licenseInfo) {
        return SubscriptionLicensingUtil.isSubscriptionLicensingEnabled() && licenseInfo instanceof SubscriptionLicenseInfo;
    }

    private static SubscriptionService buildSubscriptionService(SubscriptionLicenseInfo serviceSubscriptionLicenseInfo) {
        SubscriptionService service = new SubscriptionService();
        service.setServiceId(serviceSubscriptionLicenseInfo.getSubscriptionServiceInfo().getId());
        service.setProperties(serviceSubscriptionLicenseInfo.getSubscriptionServiceInfo().getProperties());
        return service;
    }

    private static SubscriptionEntitlementAccount buildSubscriptionEntitlementAccount(SubscriptionLicenseInfo serviceSubscriptionLicenseInfo) {
        SubscriptionEntitlementAccount entitlementAccount = new SubscriptionEntitlementAccount();
        entitlementAccount.setNumber(serviceSubscriptionLicenseInfo.getEntitlementAccountInfo().getNumber());
        entitlementAccount.setName(serviceSubscriptionLicenseInfo.getEntitlementAccountInfo().getName());
        return entitlementAccount;
    }

    private static SubscriptionInfo buildSubscriptionInfo(SubscriptionEntitlementAccount entitlementAccount, SubscriptionService service) {
        SubscriptionInfo subscriptionInfo = new SubscriptionInfo();
        subscriptionInfo.entitlementAccount = entitlementAccount;
        subscriptionInfo.service = service;
        return subscriptionInfo;
    }
}

