/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.myvmwaresync.impl;

import com.vmware.license.client.cis.ds.LicenseUiScope;
import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.license.client.cis.myvmwaresync.MyVMwareOnlineSyncEditor;
import com.vmware.license.client.cis.myvmwaresync.MyVMwareOnlineSyncException;
import com.vmware.license.client.cis.myvmwaresync.MyVMwareOnlineSyncObjectsFormatter;
import com.vmware.license.client.cis.myvmwaresync.MyVMwareSyncEditor;
import com.vmware.license.client.cis.myvmwaresync.client.MyVMwareClientProvider;
import com.vmware.license.client.cis.myvmwaresync.client.MyVMwareClientProviderException;
import com.vmware.license.client.cis.myvmwaresync.client.MyVMwareClientProviderResult;
import com.vmware.license.client.cis.myvmwaresync.ds.MyVMwareAuthenticationInfo;
import com.vmware.license.client.cis.myvmwaresync.ds.MyVMwareAuthenticationToken;
import com.vmware.license.client.cis.myvmwaresync.ds.MyVMwareEntitlementAccount;
import com.vmware.license.client.cis.myvmwaresync.ds.MyVMwareFolder;
import com.vmware.license.client.cis.myvmwaresync.ds.results.MyVMwareOnlineSyncCheckReportGenerationStatusResult;
import com.vmware.license.client.cis.myvmwaresync.ds.results.MyVMwareOnlineSyncCredentialsResult;
import com.vmware.license.client.cis.myvmwaresync.ds.results.MyVMwareOnlineSyncFoldersResult;
import com.vmware.license.client.cis.myvmwaresync.ds.results.MyVMwareOnlineSyncInitiateReportGenerationResult;
import com.vmware.license.client.cis.myvmwaresync.ds.results.MyVMwareOnlineSyncPreviewResult;
import com.vmware.license.client.cis.myvmwaresync.ds.results.MyVMwareSyncPreviewResult;
import com.vmware.license.client.cis.myvmwaresync.ds.specs.MyVMwareOnlineSyncCheckReportGenerationStatusSpec;
import com.vmware.license.client.cis.myvmwaresync.ds.specs.MyVMwareOnlineSyncCredentialsSpec;
import com.vmware.license.client.cis.myvmwaresync.ds.specs.MyVMwareOnlineSyncFoldersSpec;
import com.vmware.license.client.cis.myvmwaresync.ds.specs.MyVMwareOnlineSyncInitiateReportGenerationSpec;
import com.vmware.license.client.cis.myvmwaresync.ds.specs.MyVMwareOnlineSyncPreviewSpec;
import com.vmware.license.client.cis.myvmwaresync.ds.specs.MyVMwareOnlineSyncSpec;
import com.vmware.license.client.cis.myvmwaresync.ds.specs.MyVMwareSyncPreviewSpec;
import com.vmware.license.client.cis.util.LicenseScopeUtil;
import com.vmware.license.myvmware.client.authn.AuthenticationToken;
import com.vmware.license.myvmware.client.entitlementreport.EntitlementAccount;
import com.vmware.license.myvmware.client.entitlementreport.EntitlementReport;
import com.vmware.license.myvmware.client.entitlementreport.EntitlementReportGenerationSpec;
import com.vmware.license.myvmware.client.entitlementreport.Folder;
import com.vmware.license.myvmware.client.entitlementreport.MyVMwareEntitlementReportClient;
import com.vmware.license.myvmware.client.entitlementreport.RootFolder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MyVMwareOnlineSyncEditorImpl
implements MyVMwareOnlineSyncEditor {
    private static final int USER_CREDENTIALS_MAX_CHARS = 256;
    private final Log _logger = LogFactory.getLog(MyVMwareOnlineSyncEditorImpl.class);
    private MyVMwareOnlineSyncObjectsFormatter _myVMwareOnlineSyncObjectsFormatter = null;
    private MyVMwareClientProvider _myVMwareClientProvider = null;
    private MyVMwareSyncEditor _myVMwareSyncEditor = null;

    public MyVMwareOnlineSyncEditorImpl(MyVMwareClientProvider myVMwareClientProvider, MyVMwareSyncEditor myVMwareSyncEditor) {
        this._myVMwareClientProvider = myVMwareClientProvider;
        this._myVMwareSyncEditor = myVMwareSyncEditor;
    }

    public void setMyVMwareOnlineSyncObjectsFormatter(MyVMwareOnlineSyncObjectsFormatter myVMwareOnlineSyncObjectsFormatter) {
        this._myVMwareOnlineSyncObjectsFormatter = myVMwareOnlineSyncObjectsFormatter;
    }

    @Override
    public MyVMwareOnlineSyncCredentialsResult getUserEntitlementAccounts(MyVMwareOnlineSyncCredentialsSpec credentialsSpec) throws MyVMwareOnlineSyncException {
        this.validateOnlineSyncSpecSanity(credentialsSpec);
        try {
            MyVMwareClientProviderResult myVMwareClientProviderResult = this.getMyVMwareClient(credentialsSpec.authenticationInfo);
            MyVMwareEntitlementReportClient myVMwareClient = myVMwareClientProviderResult.getClient();
            if (this._logger.isDebugEnabled()) {
                this._logger.debug((Object)"(Before call): Get the entitlement accounts of the current user.");
            }
            EntitlementAccount[] entitlementAccounts = myVMwareClient.getEntitlementAccounts();
            if (this._logger.isDebugEnabled()) {
                this._logger.debug((Object)"(After call): Get the entitlement accounts of the current user.");
            }
            MyVMwareEntitlementAccount[] uiEntitlementAccounts = this.buildUiEntitlementAccounts(entitlementAccounts);
            MyVMwareAuthenticationInfo uiAuthenticationInfo = this.buildUiAuthenticationInfo(myVMwareClientProviderResult);
            MyVMwareOnlineSyncCredentialsResult result = this.buildCredentialsResult(uiEntitlementAccounts, uiAuthenticationInfo);
            return result;
        }
        catch (Exception e) {
            throw new MyVMwareOnlineSyncException(e);
        }
    }

    @Override
    public MyVMwareOnlineSyncFoldersResult getEntitlementAccountFolders(MyVMwareOnlineSyncFoldersSpec foldersSpec) throws MyVMwareOnlineSyncException {
        this.validateOnlineSyncSpecSanity(foldersSpec);
        if (foldersSpec.eaNumber == null) {
            throw new IllegalArgumentException("An entitlement account id must be specified in the spec parameter.");
        }
        try {
            MyVMwareClientProviderResult myVMwareClientProviderResult = this.getMyVMwareClient(foldersSpec.authenticationInfo);
            MyVMwareEntitlementReportClient myVMwareClient = myVMwareClientProviderResult.getClient();
            if (this._logger.isDebugEnabled()) {
                this._logger.debug((Object)"(Before call): Get the folders of a specific entitlement account.");
            }
            RootFolder rootFolder = myVMwareClient.getEntitlementAccountFolders(foldersSpec.eaNumber);
            if (this._logger.isDebugEnabled()) {
                this._logger.debug((Object)"(After call): Get the folders of a specific entitlement account.");
            }
            MyVMwareFolder[] folders = this.buildUiEntitlementAccountFolders(foldersSpec.eaNumber, rootFolder);
            MyVMwareAuthenticationInfo uiAuthenticationInfo = this.buildUiAuthenticationInfo(myVMwareClientProviderResult);
            MyVMwareOnlineSyncFoldersResult result = this.buildValidateMyVMwareFoldersResult(folders, uiAuthenticationInfo);
            return result;
        }
        catch (Exception e) {
            throw new MyVMwareOnlineSyncException(e);
        }
    }

    @Override
    public MyVMwareOnlineSyncInitiateReportGenerationResult initiateReportGeneration(MyVMwareOnlineSyncInitiateReportGenerationSpec initiateReportGenerationSpec) throws MyVMwareOnlineSyncException {
        this.validateOnlineSyncSpecSanity(initiateReportGenerationSpec);
        if (initiateReportGenerationSpec.accountsToFolderIds == null) {
            throw new IllegalArgumentException("The entitlement accounts to folder ids array cannot be null in the input spec parameter.");
        }
        try {
            MyVMwareClientProviderResult myVMwareClientProviderResult = this.getMyVMwareClient(initiateReportGenerationSpec.authenticationInfo);
            MyVMwareEntitlementReportClient myVMwareClient = myVMwareClientProviderResult.getClient();
            EntitlementReportGenerationSpec generationSpec = this.buildEntitlementReportGenerationSpec(initiateReportGenerationSpec);
            if (this._logger.isDebugEnabled()) {
                this._logger.debug((Object)"(Before call): Initiate the My VMware report generation for the selected entitlement accounts/folders.");
            }
            String reportGenerationTaskId = myVMwareClient.initiateEntitlementReportGeneration(generationSpec);
            if (this._logger.isDebugEnabled()) {
                this._logger.debug((Object)"(After call): Initiate the My VMware report generation for the selected entitlement accounts/folders.");
            }
            MyVMwareAuthenticationInfo uiAuthenticationInfo = this.buildUiAuthenticationInfo(myVMwareClientProviderResult);
            MyVMwareOnlineSyncInitiateReportGenerationResult result = this.buildValidateInitiateReportGenerationResult(reportGenerationTaskId, uiAuthenticationInfo);
            return result;
        }
        catch (Exception e) {
            throw new MyVMwareOnlineSyncException(e);
        }
    }

    @Override
    public MyVMwareOnlineSyncCheckReportGenerationStatusResult checkReportGenerationStatus(MyVMwareOnlineSyncCheckReportGenerationStatusSpec checkReportStatusSpec) throws MyVMwareOnlineSyncException {
        this.validateOnlineSyncSpecSanity(checkReportStatusSpec);
        if (checkReportStatusSpec.reportGenerationTaskId == null) {
            throw new IllegalArgumentException("The id of the report generation task must not be null in the input spec parameter.");
        }
        try {
            MyVMwareClientProviderResult myVMwareClientProviderResult = this.getMyVMwareClient(checkReportStatusSpec.authenticationInfo);
            MyVMwareEntitlementReportClient myVMwareClient = myVMwareClientProviderResult.getClient();
            boolean isReportGenerated = myVMwareClient.isEntitlementReportGenerationComplete(checkReportStatusSpec.reportGenerationTaskId);
            MyVMwareAuthenticationInfo uiAuthenticationInfo = this.buildUiAuthenticationInfo(myVMwareClientProviderResult);
            MyVMwareOnlineSyncCheckReportGenerationStatusResult result = this.buildValidateCheckReportGenerationStatusResult(isReportGenerated, uiAuthenticationInfo);
            return result;
        }
        catch (Exception e) {
            throw new MyVMwareOnlineSyncException(e);
        }
    }

    @Override
    public MyVMwareOnlineSyncPreviewResult previewOnlineSync(MyVMwareOnlineSyncPreviewSpec onlineSyncPreviewSpec) throws MyVMwareOnlineSyncException {
        this.validateOnlineSyncSpecSanity(onlineSyncPreviewSpec);
        if (onlineSyncPreviewSpec.reportGenerationTaskId == null) {
            throw new IllegalArgumentException("The id of the report to download must not be null in the input spec parameter.");
        }
        if (onlineSyncPreviewSpec.scope == null) {
            throw new IllegalArgumentException("The scope of the license for the report to download must not be null in the input spec parameter.");
        }
        try {
            MyVMwareClientProviderResult myVMwareClientProviderResult = this.getMyVMwareClient(onlineSyncPreviewSpec.authenticationInfo);
            MyVMwareEntitlementReportClient myVMwareClient = myVMwareClientProviderResult.getClient();
            if (this._logger.isDebugEnabled()) {
                this._logger.debug((Object)"(Before call): Get the generated My VMware report.");
            }
            EntitlementReport entitlementReport = myVMwareClient.getEntitlementReport(onlineSyncPreviewSpec.reportGenerationTaskId);
            if (this._logger.isDebugEnabled()) {
                this._logger.debug((Object)"(After call): Get the generated My VMware report.");
            }
            MyVMwareSyncPreviewSpec myVMwareSyncPreviewSpec = this.buildMyVMwareSyncPreviewSpec(onlineSyncPreviewSpec.scope, entitlementReport.getData());
            LicenseScope licenseScope = LicenseScopeUtil.getLicenseScopeByUiScope(onlineSyncPreviewSpec.scope);
            MyVMwareSyncPreviewResult myVMwareSyncPreviewResult = this._myVMwareSyncEditor.previewSyncFromMyVMware(myVMwareSyncPreviewSpec, licenseScope);
            MyVMwareAuthenticationInfo uiAuthenticationInfo = this.buildUiAuthenticationInfo(myVMwareClientProviderResult);
            MyVMwareOnlineSyncPreviewResult result = this.buildValidateDownloadGeneratedReportResult(myVMwareSyncPreviewResult, uiAuthenticationInfo);
            return result;
        }
        catch (Exception e) {
            throw new MyVMwareOnlineSyncException(e);
        }
    }

    private MyVMwareSyncPreviewSpec buildMyVMwareSyncPreviewSpec(LicenseUiScope licenseUiScope, byte[] entitlementReportData) {
        MyVMwareSyncPreviewSpec myVMwareSyncPreviewSpec = new MyVMwareSyncPreviewSpec();
        myVMwareSyncPreviewSpec.scope = licenseUiScope;
        myVMwareSyncPreviewSpec.myVMwareFileContent = entitlementReportData;
        return myVMwareSyncPreviewSpec;
    }

    private void validateOnlineSyncSpecSanity(MyVMwareOnlineSyncSpec onlineSyncSpec) {
        if (onlineSyncSpec == null) {
            throw new IllegalArgumentException("The Online Sync spec parameter should not be null");
        }
        if (onlineSyncSpec.authenticationInfo == null) {
            throw new IllegalArgumentException("The authenticationInfo must not be null in the Online Sync spec parameter.");
        }
    }

    private EntitlementReportGenerationSpec buildEntitlementReportGenerationSpec(MyVMwareOnlineSyncInitiateReportGenerationSpec uiInitiateGenerationSpec) {
        EntitlementReportGenerationSpec.EntitlementReportAccountFolderSpec[] accountFolderSpecs = new EntitlementReportGenerationSpec.EntitlementReportAccountFolderSpec[uiInitiateGenerationSpec.accountsToFolderIds.length];
        for (int i = 0; i < uiInitiateGenerationSpec.accountsToFolderIds.length; ++i) {
            String entitlementAccountId = uiInitiateGenerationSpec.accountsToFolderIds[i].getEntitlementAccountId();
            String[] folderIds = uiInitiateGenerationSpec.accountsToFolderIds[i].getFolderIds();
            accountFolderSpecs[i] = new EntitlementReportGenerationSpec.EntitlementReportAccountFolderSpec(entitlementAccountId, folderIds);
        }
        EntitlementReportGenerationSpec generationSpec = new EntitlementReportGenerationSpec(accountFolderSpecs, uiInitiateGenerationSpec.fromDate, uiInitiateGenerationSpec.toDate);
        return generationSpec;
    }

    private MyVMwareClientProviderResult getMyVMwareClient(MyVMwareAuthenticationInfo authenticationInfo) throws MyVMwareClientProviderException {
        MyVMwareClientProviderResult clientProviderResult;
        if (authenticationInfo.getAuthenticationToken() == null) {
            if (this._logger.isDebugEnabled()) {
                this._logger.debug((Object)"(Before call): Get a My VMware client by username and password.");
            }
            String username = authenticationInfo.getUsername();
            String password = authenticationInfo.getPassword();
            if (username != null && username.length() > 256) {
                username = username.substring(0, 256);
            }
            if (password != null && password.length() > 256) {
                password = password.substring(0, 256);
            }
            clientProviderResult = this._myVMwareClientProvider.newClient(username, password);
            if (this._logger.isDebugEnabled()) {
                this._logger.debug((Object)"(After call): Get a My VMware client by username and password.");
            }
        } else {
            MyVMwareAuthenticationToken uiAuthenticationToken = authenticationInfo.getAuthenticationToken();
            AuthenticationToken authenticationToken = new AuthenticationToken(uiAuthenticationToken.getTokenValue(), uiAuthenticationToken.getExpirationTime());
            clientProviderResult = this._myVMwareClientProvider.newClient(authenticationToken);
        }
        return clientProviderResult;
    }

    private MyVMwareAuthenticationInfo buildUiAuthenticationInfo(MyVMwareClientProviderResult myVMwareClientProviderResult) {
        AuthenticationToken authenticationToken = myVMwareClientProviderResult.getAuthenticationToken();
        MyVMwareAuthenticationToken uiAuthenticationToken = this.buildUiAuthenticationToken(authenticationToken);
        MyVMwareAuthenticationInfo uiAuthenticationInfo = new MyVMwareAuthenticationInfo();
        uiAuthenticationInfo.setAuthenticationToken(uiAuthenticationToken);
        return uiAuthenticationInfo;
    }

    private MyVMwareAuthenticationToken buildUiAuthenticationToken(AuthenticationToken serviceAuthenticationToken) {
        MyVMwareAuthenticationToken uiAuthenticationToken = new MyVMwareAuthenticationToken();
        uiAuthenticationToken.setTokenValue(serviceAuthenticationToken.getTokenValue());
        uiAuthenticationToken.setExpirationTime(serviceAuthenticationToken.getExpirationTime());
        return uiAuthenticationToken;
    }

    private MyVMwareEntitlementAccount[] buildUiEntitlementAccounts(EntitlementAccount[] entitlementAccounts) {
        if (entitlementAccounts == null) {
            return new MyVMwareEntitlementAccount[0];
        }
        MyVMwareEntitlementAccount[] uiEntitlementAccounts = new MyVMwareEntitlementAccount[entitlementAccounts.length];
        for (int i = 0; i < entitlementAccounts.length; ++i) {
            EntitlementAccount entitlementAccount = entitlementAccounts[i];
            MyVMwareEntitlementAccount uiEntitlementAccount = new MyVMwareEntitlementAccount();
            uiEntitlementAccount.setEaNumber(entitlementAccount.getEaNumber());
            if (this._myVMwareOnlineSyncObjectsFormatter != null) {
                this._myVMwareOnlineSyncObjectsFormatter.formatEntitlementAccount(uiEntitlementAccount, entitlementAccount);
            }
            uiEntitlementAccounts[i] = uiEntitlementAccount;
        }
        return uiEntitlementAccounts;
    }

    private MyVMwareFolder[] buildUiEntitlementAccountFolders(String eaNumber, RootFolder rootFolder) {
        MyVMwareFolder uiRootFolder;
        if (rootFolder == null) {
            return new MyVMwareFolder[0];
        }
        int subFoldersCount = 0;
        if (rootFolder.getSubFolders() != null) {
            subFoldersCount = rootFolder.getSubFolders().length;
        }
        MyVMwareFolder[] uiFolders = new MyVMwareFolder[subFoldersCount + 1];
        uiFolders[0] = uiRootFolder = this.buildUiFolder(eaNumber, (Folder)rootFolder);
        if (this._myVMwareOnlineSyncObjectsFormatter != null) {
            this._myVMwareOnlineSyncObjectsFormatter.formatFolder(uiRootFolder, (Folder)rootFolder);
        }
        if (rootFolder.getSubFolders() == null) {
            return uiFolders;
        }
        for (int i = 0; i < rootFolder.getSubFolders().length; ++i) {
            Folder folder = rootFolder.getSubFolders()[i];
            MyVMwareFolder uiFolder = this.buildUiFolder(eaNumber, folder);
            if (this._myVMwareOnlineSyncObjectsFormatter != null) {
                this._myVMwareOnlineSyncObjectsFormatter.formatFolder(uiFolder, folder);
            }
            uiFolders[i + 1] = uiFolder;
        }
        return uiFolders;
    }

    private MyVMwareFolder buildUiFolder(String eaNumber, Folder folder) {
        MyVMwareFolder uiFolder = new MyVMwareFolder();
        uiFolder.setEaNumber(eaNumber);
        uiFolder.setFolderId(folder.getFolderId());
        uiFolder.setSubFolderCount(folder.getSubFolderCount());
        uiFolder.setIsRootFolder(folder instanceof RootFolder);
        return uiFolder;
    }

    private MyVMwareOnlineSyncCredentialsResult buildCredentialsResult(MyVMwareEntitlementAccount[] uiEntitlementAccounts, MyVMwareAuthenticationInfo uiAuthenticationInfo) {
        MyVMwareOnlineSyncCredentialsResult credentialsResult = new MyVMwareOnlineSyncCredentialsResult();
        credentialsResult.entitlementAccounts = uiEntitlementAccounts;
        credentialsResult.authenticationInfo = uiAuthenticationInfo;
        return credentialsResult;
    }

    private MyVMwareOnlineSyncFoldersResult buildValidateMyVMwareFoldersResult(MyVMwareFolder[] folders, MyVMwareAuthenticationInfo uiAuthenticationInfo) {
        MyVMwareOnlineSyncFoldersResult foldersResult = new MyVMwareOnlineSyncFoldersResult();
        foldersResult.folders = folders;
        foldersResult.authenticationInfo = uiAuthenticationInfo;
        return foldersResult;
    }

    private MyVMwareOnlineSyncInitiateReportGenerationResult buildValidateInitiateReportGenerationResult(String reportGenerationTaskId, MyVMwareAuthenticationInfo uiAuthenticationInfo) {
        MyVMwareOnlineSyncInitiateReportGenerationResult result = new MyVMwareOnlineSyncInitiateReportGenerationResult();
        result.reportGenerationTaskId = reportGenerationTaskId;
        result.authenticationInfo = uiAuthenticationInfo;
        return result;
    }

    private MyVMwareOnlineSyncCheckReportGenerationStatusResult buildValidateCheckReportGenerationStatusResult(boolean isReportGenerated, MyVMwareAuthenticationInfo uiAuthenticationInfo) {
        MyVMwareOnlineSyncCheckReportGenerationStatusResult result = new MyVMwareOnlineSyncCheckReportGenerationStatusResult();
        result.isReportGenerated = isReportGenerated;
        result.authenticationInfo = uiAuthenticationInfo;
        return result;
    }

    private MyVMwareOnlineSyncPreviewResult buildValidateDownloadGeneratedReportResult(MyVMwareSyncPreviewResult myVMwareSyncPreviewResult, MyVMwareAuthenticationInfo uiAuthenticationInfo) {
        MyVMwareOnlineSyncPreviewResult result = new MyVMwareOnlineSyncPreviewResult();
        result.syncPreviewResult = myVMwareSyncPreviewResult;
        result.authenticationInfo = uiAuthenticationInfo;
        return result;
    }
}

