/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.myvmwaresync.impl;

import com.vmware.cis.license.client.LicenseClient;
import com.vmware.license.client.cis.ls.LicenseClientProvider;
import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.license.client.cis.management.ds.License;
import com.vmware.license.client.cis.management.util.LicenseUtil;
import com.vmware.license.client.cis.myvmwaresync.MyVMwareSyncEditor;
import com.vmware.license.client.cis.myvmwaresync.MyVMwareSyncException;
import com.vmware.license.client.cis.myvmwaresync.ds.results.MyVMwareSyncPreviewResult;
import com.vmware.license.client.cis.myvmwaresync.ds.specs.MyVMwareSyncPreviewSpec;
import com.vmware.license.client.cis.myvmwaresync.util.MyVMwareSyncUtil;
import com.vmware.license.myvmware.client.sync.MyVMwareUtil;
import com.vmware.vim.binding.cis.license.management.InactiveLicensesReport;
import com.vmware.vim.binding.cis.license.management.MyVMwareLicenseReport;
import com.vmware.vim.binding.cis.license.management.SystemManagementService;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ValidationUtil;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class MyVMwareSyncEditorImpl
implements MyVMwareSyncEditor {
    private final LicenseClientProvider _licenseClientProvider;
    private final Log _logger = LogFactory.getLog(MyVMwareSyncEditorImpl.class);

    public MyVMwareSyncEditorImpl(LicenseClientProvider licenseClientProvider) {
        this._licenseClientProvider = licenseClientProvider;
    }

    @Override
    public MyVMwareSyncPreviewResult previewSyncFromMyVMware(MyVMwareSyncPreviewSpec syncPreviewSpec, LicenseScope scope) {
        MyVMwareLicenseReport myVMwareLicenseReport;
        ValidationUtil.paramsNotNull((Object[])new Object[]{syncPreviewSpec, scope});
        ValidationUtil.paramsNotNull((Object[])new Object[]{syncPreviewSpec.myVMwareFileContent});
        try {
            myVMwareLicenseReport = MyVMwareUtil.buildMyVMwareLicenseReport((byte[])syncPreviewSpec.myVMwareFileContent);
        }
        catch (IOException e) {
            throw new MyVMwareSyncException(e);
        }
        SystemManagementService sms = this.getSystemManagementService(scope);
        try {
            com.vmware.vim.binding.cis.license.management.MyVMwareSyncPreviewResult serviceSyncPreviewResult = sms.previewMyVMwareSync(myVMwareLicenseReport);
            return this.buildUiSyncPreviewResult(serviceSyncPreviewResult, scope);
        }
        catch (MethodFault fault) {
            throw new MyVMwareSyncException(fault);
        }
    }

    protected SystemManagementService getSystemManagementService(LicenseScope scope) {
        LicenseClient client = this.getLicenseClient(scope);
        return client.getSystemManagementService();
    }

    protected LicenseClient getLicenseClient(LicenseScope scope) {
        try {
            return this._licenseClientProvider.getLicenseClient(scope);
        }
        catch (Exception e) {
            throw new MyVMwareSyncException(e);
        }
    }

    protected MyVMwareSyncPreviewResult buildUiSyncPreviewResult(com.vmware.vim.binding.cis.license.management.MyVMwareSyncPreviewResult serviceSyncPreviewResult, LicenseScope scope) {
        MyVMwareSyncPreviewResult uiSyncPreviewResult = new MyVMwareSyncPreviewResult();
        uiSyncPreviewResult.licensesForMyVMwareInfoUpdate = LicenseUtil.createLicenses(serviceSyncPreviewResult.getMatchedLicenses(), scope);
        License[] licensesForAdd = LicenseUtil.createLicenses(serviceSyncPreviewResult.getNewLicenses(), scope);
        MyVMwareSyncUtil.updateDefaultNewLicensesNames(licensesForAdd, serviceSyncPreviewResult.getInventoryLicensesTotal());
        uiSyncPreviewResult.licensesForAdd = licensesForAdd;
        uiSyncPreviewResult.isMyVMwareFileInCorrectFormat = ArrayUtil.isNullOrEmpty((Object[])serviceSyncPreviewResult.getMyVMwareReportErrors());
        uiSyncPreviewResult.inactiveLicensesReport = this.buildUiInactiveLicensesReport(serviceSyncPreviewResult.getInactiveLicensesReport());
        uiSyncPreviewResult.upgradedLicensesReport = this.buildUiInactiveLicensesReport(serviceSyncPreviewResult.getUpgradedLicensesReport());
        return uiSyncPreviewResult;
    }

    protected com.vmware.license.client.cis.management.ds.InactiveLicensesReport buildUiInactiveLicensesReport(InactiveLicensesReport serviceReport) {
        if (serviceReport == null) {
            return null;
        }
        byte[] reportContent = null;
        try {
            reportContent = MyVMwareUtil.getInactiveLicensesReportContent((InactiveLicensesReport)serviceReport);
        }
        catch (IOException e) {
            this._logger.warn((Object)"Unable to get inactive licenses report content: ", (Throwable)e);
        }
        if (reportContent == null) {
            return null;
        }
        com.vmware.license.client.cis.management.ds.InactiveLicensesReport uiReport = new com.vmware.license.client.cis.management.ds.InactiveLicensesReport();
        uiReport.setContent(reportContent);
        uiReport.setLicensesCount(serviceReport.getInactiveLicensesTotal());
        return uiReport;
    }
}

