/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.reports.impl;

import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.license.client.cis.ls.authz.AuthorizationManager;
import com.vmware.license.client.cis.management.util.ManagementUtil;
import com.vmware.license.client.cis.management.util.UriUtil;
import com.vmware.license.client.cis.reports.LicenseReportScope;
import com.vmware.license.client.cis.reports.ReportEditor;
import com.vmware.license.client.cis.reports.ReportException;
import com.vmware.license.client.cis.reports.ds.AssetReport;
import com.vmware.license.client.cis.reports.ds.LicenseReport;
import com.vmware.license.client.cis.reports.ds.LicensingDataDumpReport;
import com.vmware.license.client.cis.reports.ds.ProductReport;
import com.vmware.license.client.cis.util.LicenseScopeUtil;
import com.vmware.vise.util.ValidationUtil;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuthorizationReportEditorWrapperImpl
implements ReportEditor {
    private final ReportEditor _reportEditor;
    private final AuthorizationManager _authorizationManager;
    private final Log _logger = LogFactory.getLog(AuthorizationReportEditorWrapperImpl.class);

    public AuthorizationReportEditorWrapperImpl(ReportEditor reportEditor, AuthorizationManager authorizationManager) {
        this._reportEditor = reportEditor;
        this._authorizationManager = authorizationManager;
    }

    @Override
    public ProductReport[] getProductReports(URI[] productReportUris, LicenseReportScope licenseReportScope) {
        this.validateLicensingPrivilegeGranted(licenseReportScope);
        ProductReport[] productReports = this._reportEditor.getProductReports(productReportUris, licenseReportScope);
        return productReports;
    }

    @Override
    public LicenseReport[] getLicenseReportsForProduct(URI productReportUri) {
        UriUtil.validateProductReportUri(productReportUri);
        LicenseReportScope licenseReportScope = LicenseScopeUtil.getLicenseReportScopeByUiObjectUri(productReportUri);
        this.validateLicensingPrivilegeGranted(licenseReportScope);
        LicenseReport[] licenseReports = this._reportEditor.getLicenseReportsForProduct(productReportUri);
        return licenseReports;
    }

    @Override
    public AssetReport[] getAssetReports(URI productReportUri, URI licenseReportUri, String costUnitId) {
        UriUtil.validateProductReportUri(productReportUri);
        LicenseReportScope licenseReportScope = LicenseScopeUtil.getLicenseReportScopeByUiObjectUri(productReportUri);
        this.validateLicensingPrivilegeGranted(licenseReportScope);
        AssetReport[] assetReports = this._reportEditor.getAssetReports(productReportUri, licenseReportUri, costUnitId);
        return assetReports;
    }

    @Override
    public LicensingDataDumpReport[] getLicensingDataDumpReports(LicenseReportScope licenseReportScope) {
        this.validateLicensingPrivilegeGranted(licenseReportScope);
        LicensingDataDumpReport[] licensingDataDumpReports = this._reportEditor.getLicensingDataDumpReports(licenseReportScope);
        return licensingDataDumpReports;
    }

    private void validateLicensingPrivilegeGranted(LicenseReportScope licenseReportScope) {
        boolean licensingPrivilegeGranted;
        ValidationUtil.paramsNotNull((Object[])new Object[]{licenseReportScope});
        LicenseScope scope = licenseReportScope.getLicenseScope();
        ValidationUtil.paramsNotNull((Object[])new Object[]{scope});
        try {
            licensingPrivilegeGranted = this._authorizationManager.isLicensingAdminPrivilegeGranted(scope);
        }
        catch (Exception e) {
            this._logger.warn((Object)"Unable to retrieve licensing privileges information. Assuming access is not granted.", (Throwable)e);
            licensingPrivilegeGranted = false;
        }
        if (!licensingPrivilegeGranted) {
            throw new ReportException(ManagementUtil.getLocalizedString("error.lsPrivilegeNotGranted"));
        }
    }
}

