/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.reports.impl;

import com.vmware.license.client.cis.reports.LicenseReportScope;
import com.vmware.license.client.cis.reports.ReportEditor;
import com.vmware.license.client.cis.reports.ReportObjectsFormatter;
import com.vmware.license.client.cis.reports.ds.AssetReport;
import com.vmware.license.client.cis.reports.ds.LicenseReport;
import com.vmware.license.client.cis.reports.ds.LicensingDataDumpReport;
import com.vmware.license.client.cis.reports.ds.ProductReport;
import java.net.URI;

public class FormattingReportEditorWrapperImpl
implements ReportEditor {
    private final ReportEditor _reportEditor;
    private final ReportObjectsFormatter _formatter;

    public FormattingReportEditorWrapperImpl(ReportEditor reportEditor, ReportObjectsFormatter reportObjectsFormatter) {
        this._reportEditor = reportEditor;
        this._formatter = reportObjectsFormatter;
    }

    @Override
    public ProductReport[] getProductReports(URI[] productReportUris, LicenseReportScope licenseReportScope) {
        ProductReport[] productReports = this._reportEditor.getProductReports(productReportUris, licenseReportScope);
        this._formatter.formatProductReports(productReports);
        return productReports;
    }

    @Override
    public LicenseReport[] getLicenseReportsForProduct(URI productUri) {
        LicenseReport[] licenseReports = this._reportEditor.getLicenseReportsForProduct(productUri);
        this._formatter.formatLicenseReports(licenseReports);
        return licenseReports;
    }

    @Override
    public AssetReport[] getAssetReports(URI productReportUri, URI licenseReportUri, String costUnitId) {
        AssetReport[] assetReports = this._reportEditor.getAssetReports(productReportUri, licenseReportUri, costUnitId);
        this._formatter.formatAssetReports(assetReports);
        return assetReports;
    }

    @Override
    public LicensingDataDumpReport[] getLicensingDataDumpReports(LicenseReportScope licenseReportScope) {
        LicensingDataDumpReport[] licensingDataDumpReports = this._reportEditor.getLicensingDataDumpReports(licenseReportScope);
        this._formatter.formatLicensingDataDumpReports(licensingDataDumpReports);
        return licensingDataDumpReports;
    }
}

