/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.reports.impl;

import com.vmware.cis.license.client.LicenseClient;
import com.vmware.license.client.cis.ls.LicenseClientProvider;
import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.license.client.cis.management.util.UriUtil;
import com.vmware.license.client.cis.reports.LicenseReportScope;
import com.vmware.license.client.cis.reports.ReportEditor;
import com.vmware.license.client.cis.reports.ReportException;
import com.vmware.license.client.cis.reports.ds.AssetReport;
import com.vmware.license.client.cis.reports.ds.LicenseReport;
import com.vmware.license.client.cis.reports.ds.LicensingDataDumpReport;
import com.vmware.license.client.cis.reports.ds.ProductReport;
import com.vmware.license.client.cis.reports.impl.ReportUtil;
import com.vmware.license.client.cis.util.DateUtil;
import com.vmware.license.client.cis.util.LicenseScopeUtil;
import com.vmware.vim.binding.cis.license.report.DumpResult;
import com.vmware.vim.binding.cis.license.report.ReportAssetResult;
import com.vmware.vim.binding.cis.license.report.ReportLicenseResult;
import com.vmware.vim.binding.cis.license.report.ReportProductResult;
import com.vmware.vim.binding.cis.license.report.ReportProductUtilization;
import com.vmware.vim.binding.cis.license.report.ReportService;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ValidationUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;

public class ReportEditorImpl
implements ReportEditor {
    private final LicenseClientProvider _licenseClientProvider;

    public ReportEditorImpl(LicenseClientProvider licenseClientProvider) {
        this._licenseClientProvider = licenseClientProvider;
    }

    @Override
    public ProductReport[] getProductReports(URI[] productReportUris, LicenseReportScope licenseReportScope) {
        UriUtil.validateProductReportUris(productReportUris);
        ReportProductResult reportProductResult = this.queryReportProductsUtilizations(licenseReportScope);
        ReportProductUtilization[] filteredReportProductUtilizations = this.filterReportProductUtilizationsById(reportProductResult.getReportProductUtilizations(), productReportUris);
        reportProductResult.setReportProductUtilizations(filteredReportProductUtilizations);
        return ReportUtil.createProductReports(reportProductResult.getReportProductUtilizations(), licenseReportScope);
    }

    @Override
    public LicenseReport[] getLicenseReportsForProduct(URI productReportUri) {
        LicenseReportScope licenseReportScope = LicenseScopeUtil.getLicenseReportScopeByUiObjectUri(productReportUri);
        String productId = UriUtil.extractObjectIdAsString(productReportUri);
        ReportLicenseResult reportLicenseResult = this.queryReportLicensesUtilizationsByProduct(productId, licenseReportScope);
        return ReportUtil.createLicenseReports(reportLicenseResult.getReportLicenseUtilizations(), licenseReportScope);
    }

    @Override
    public AssetReport[] getAssetReports(URI productReportUri, URI licenseReportUri, String costUnitId) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{productReportUri, licenseReportUri});
        URI licenseId = UriUtil.extractObjectIdAsUri(licenseReportUri);
        String productId = UriUtil.extractObjectIdAsString(productReportUri);
        LicenseReportScope licenseReportScope = LicenseScopeUtil.getLicenseReportScopeByUiObjectUri(productReportUri);
        ReportAssetResult reportAssetResult = this.queryReportAssetsUtilizationsByLicense(productId, licenseId, costUnitId, licenseReportScope);
        return ReportUtil.createAssetReports(reportAssetResult.getReportAssetUtilizations(), licenseReportScope);
    }

    @Override
    public LicensingDataDumpReport[] getLicensingDataDumpReports(LicenseReportScope licenseReportScope) {
        Calendar start = DateUtil.createUTCCalendar(licenseReportScope.getStartDate());
        Calendar end = DateUtil.createUTCCalendar(licenseReportScope.getEndDate());
        ReportService reportService = this.getReportService(licenseReportScope);
        DumpResult dumpResult = null;
        try {
            dumpResult = reportService.getUsageDump(start, end);
        }
        catch (MethodFault fault) {
            throw new ReportException(fault);
        }
        LicensingDataDumpReport licensingDataDumpReport = ReportUtil.createLicensingDataDumpReport(dumpResult.getDump(), licenseReportScope);
        return new LicensingDataDumpReport[]{licensingDataDumpReport};
    }

    private ReportProductUtilization[] filterReportProductUtilizationsById(ReportProductUtilization[] reportProductUtilizations, URI[] reportProductUris) {
        if (ArrayUtil.isNullOrEmpty((Object[])reportProductUtilizations)) {
            return null;
        }
        if (ArrayUtil.isNullOrEmpty((Object[])reportProductUris)) {
            return reportProductUtilizations;
        }
        ArrayList<ReportProductUtilization> filteredUtilizations = new ArrayList<ReportProductUtilization>();
        for (URI reportProductUri : reportProductUris) {
            String reportProductId = UriUtil.extractObjectIdAsString(reportProductUri);
            ReportProductUtilization reportProductUtilization = this.getReportProductUtilizationById(reportProductUtilizations, reportProductId);
            if (reportProductUtilization == null) continue;
            filteredUtilizations.add(reportProductUtilization);
        }
        return filteredUtilizations.toArray(new ReportProductUtilization[filteredUtilizations.size()]);
    }

    private ReportProductUtilization getReportProductUtilizationById(ReportProductUtilization[] reportProductUtilizations, String id) {
        for (ReportProductUtilization reportProductUtilization : reportProductUtilizations) {
            if (!id.equals(reportProductUtilization.getProduct().getId())) continue;
            return reportProductUtilization;
        }
        return null;
    }

    private ReportProductResult queryReportProductsUtilizations(LicenseReportScope licenseReportScope) {
        Calendar start = DateUtil.createUTCCalendar(licenseReportScope.getStartDate());
        Calendar end = DateUtil.createUTCCalendar(licenseReportScope.getEndDate());
        ReportService reportService = this.getReportService(licenseReportScope);
        try {
            return reportService.queryReportProductsUtilizations(start, end);
        }
        catch (MethodFault fault) {
            throw new ReportException(fault);
        }
    }

    private ReportLicenseResult queryReportLicensesUtilizationsByProduct(String productId, LicenseReportScope licenseReportScope) {
        Calendar start = DateUtil.createUTCCalendar(licenseReportScope.getStartDate());
        Calendar end = DateUtil.createUTCCalendar(licenseReportScope.getEndDate());
        ReportService reportService = this.getReportService(licenseReportScope);
        try {
            return reportService.queryReportLicensesUtilizationsByProduct(productId, start, end);
        }
        catch (MethodFault fault) {
            throw new ReportException(fault);
        }
    }

    private ReportAssetResult queryReportAssetsUtilizationsByLicense(String productId, URI licenseId, String costUnitId, LicenseReportScope licenseReportScope) {
        Calendar start = DateUtil.createUTCCalendar(licenseReportScope.getStartDate());
        Calendar end = DateUtil.createUTCCalendar(licenseReportScope.getEndDate());
        ReportService reportService = this.getReportService(licenseReportScope);
        try {
            return reportService.queryReportAssetsUtilizationsByLicense(productId, licenseId, costUnitId, start, end);
        }
        catch (MethodFault fault) {
            throw new ReportException(fault);
        }
    }

    private ReportService getReportService(LicenseReportScope licenseReportScope) {
        LicenseScope licenseScope = licenseReportScope.getLicenseScope();
        return this.getLicenseClient(licenseScope).getReportService();
    }

    private LicenseClient getLicenseClient(LicenseScope scope) {
        try {
            return this._licenseClientProvider.getLicenseClient(scope);
        }
        catch (Exception e) {
            throw new ReportException(e);
        }
    }
}

