/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.util;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class DateUtil {
    private static final long MS_IN_MINUTE = 60000L;
    private static final long MS_IN_HOUR = 3600000L;
    private static final String UTC_TIME_ZONE_ID = "UTC";

    public static Calendar createUTCCalendar(Date date) {
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone(UTC_TIME_ZONE_ID), Locale.US);
        calendar.setTime(date);
        return calendar;
    }

    public static Calendar getCalendar(Object object) {
        if (object == null) {
            return null;
        }
        if (Calendar.class.isInstance(object)) {
            return (Calendar)object;
        }
        if (Date.class.isInstance(object)) {
            return DateUtil.createUTCCalendar((Date)object);
        }
        if (Long.class.isInstance(object)) {
            return DateUtil.createUTCCalendar(new Date((Long)object));
        }
        throw new IllegalArgumentException("The object parameter is of type not supported by this method");
    }

    public static Date getDate(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        return calendar.getTime();
    }

    public static Long getTimeInMillis(Number hours, Number minutes) {
        if (hours == null && minutes == null) {
            return null;
        }
        long availableHours = hours != null ? hours.longValue() : 0L;
        long availableMinutes = minutes != null ? minutes.longValue() : 0L;
        return availableHours * 3600000L + availableMinutes * 60000L;
    }

    public static Long getRemainingTimeInMillis(Calendar fromTime, Calendar toTime) {
        if (toTime == null) {
            return null;
        }
        return fromTime == null ? toTime.getTimeInMillis() - new Date().getTime() : toTime.getTimeInMillis() - fromTime.getTimeInMillis();
    }
}

