/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.configissues.impl;

import com.vmware.opsmgmt.client.commons.util.EventMessageFormatter;
import com.vmware.opsmgmt.client.event.impl.i18n.MessageParser;
import com.vmware.opsmgmt.client.event.util.Util;
import com.vmware.vim.binding.vim.event.Event;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.event.ClientEventInfo;
import com.vmware.vise.core.model.monitor.IssueInfo;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.type;
import com.vmware.vise.messaging.amf.DataObjectProxy;
import com.vmware.vsphere.client.issue.impl.IssueAdapterBase;

@type(value="Issue,ConfigIssue")
public class ConfigIssueAdapter
extends IssueAdapterBase {
    private static final String CONFIG_ISSUE_TYPE = "ConfigIssue";
    private static final String CONFIG_ISSUE_PROPERTY_NAME = "clientConfigIssue";
    private static final String ISSUE_KEY_FORMAT = "configIssue-%d";
    private DataService _dataService;

    public ConfigIssueAdapter(DataService dataService) {
        super(CONFIG_ISSUE_TYPE);
        this._dataService = dataService;
    }

    protected IssueAdapterBase.IssueData[] getIssues(QuerySpec querySpec, IssueAdapterBase.RequestContext context) {
        ClientEventInfo[] configIssues;
        Object entity = this.extractEntityFromQuerySpec(querySpec);
        if (!(entity instanceof ManagedObjectReference)) {
            return new IssueAdapterBase.IssueData[0];
        }
        try {
            configIssues = (ClientEventInfo[])QueryUtil.getProperty((DataService)this._dataService, (Object)entity, (String)CONFIG_ISSUE_PROPERTY_NAME);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        IssueAdapterBase.IssueData[] issues = ConfigIssueAdapter.convertToConfigIssues(entity, configIssues);
        return issues;
    }

    private static IssueAdapterBase.IssueData[] convertToConfigIssues(Object entity, ClientEventInfo[] configIssues) {
        if (configIssues == null || configIssues.length == 0) {
            return new IssueAdapterBase.IssueData[0];
        }
        IssueAdapterBase.IssueData[] result = new IssueAdapterBase.IssueData[configIssues.length];
        for (int i = 0; i < configIssues.length; ++i) {
            Event serverEvent = (Event)configIssues[i].serverEvent;
            result[i] = new IssueAdapterBase.IssueData();
            result[i].key = String.format(ISSUE_KEY_FORMAT, i);
            result[i].issueInfo = new IssueInfo();
            result[i].issueInfo.entity = entity;
            result[i].issueInfo.typeDisplayName = Util.getLocalizedString("configIssue.displayName");
            result[i].issueInfo.timestamp = serverEvent.createdTime.getTime();
            EventMessageFormatter eventMessageFormatter = new EventMessageFormatter(serverEvent, configIssues[i].eventDetail.makeEventDetail(), (ManagedObjectReference)entity);
            MessageParser parser = new MessageParser(new DataObjectProxy((Object)serverEvent), serverEvent);
            String eventMessageToParse = eventMessageFormatter.getFullMessage();
            parser.parse(eventMessageToParse);
            result[i].issueInfo.description = parser.getFullFormattedMessage();
            result[i].issueInfo.details = serverEvent;
        }
        return result;
    }
}

