/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.event.impl;

import com.vmware.opsmgmt.client.commons.util.ManagedObjectTypes;
import com.vmware.opsmgmt.client.event.impl.BaseEventProcessor;
import com.vmware.opsmgmt.client.event.impl.EventsTransformer;
import com.vmware.vim.binding.vim.event.Event;
import com.vmware.vim.binding.vim.event.TaskEvent;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vise.core.model.event.ClientEventInfo;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.mixed.ManagedEntityParentLocator;
import com.vmware.vsphere.client.task.TaskSearchHelper;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ClientEventProcessor
extends BaseEventProcessor {
    private final ManagedEntityParentLocator _locator;
    private final DataService _dataService;
    private final TaskSearchHelper _taskSearchHelper;

    public ClientEventProcessor(ManagedEntityParentLocator locator, DataService dataService, DataServiceExtensionRegistry registry, TaskSearchHelper taskSearchHelper) {
        super(registry);
        this._locator = locator;
        this._dataService = dataService;
        this._taskSearchHelper = taskSearchHelper;
    }

    @Override
    protected TypeInfo getTypeInfo() {
        TypeInfo typeInfo = new TypeInfo();
        typeInfo.type = BaseEventProcessor.EVENT_TYPE;
        typeInfo.properties = new String[]{"info", "taskInfoName", "contextSensitiveMessage"};
        return typeInfo;
    }

    @Override
    protected List<ResultItem> processEventsResult(Map<ManagedObjectReference, List<Event>> events, List<MethodFault> faults, QuerySpec spec) {
        ArrayList<ClientEventInfo> clientEventInfos = new ArrayList<ClientEventInfo>();
        for (Map.Entry<ManagedObjectReference, List<Event>> entry : events.entrySet()) {
            PropertySpec[] serverEvents = entry.getValue();
            ClientEventInfo[] clientEvents = new ClientEventInfo[]{};
            try {
                for (ClientEventInfo currentEvent : clientEvents = EventsTransformer.transformToClientEvents(this._dataService, serverEvents.toArray(new Event[serverEvents.size()]), entry.getKey().getServerGuid(), this._locator, faults)) {
                    clientEventInfos.add(currentEvent);
                }
            }
            catch (Exception ex) {
                faults.add(MixedUtil.getMethodFault((Throwable)ex));
            }
        }
        ArrayList<ResultItem> result = new ArrayList<ResultItem>();
        HashSet<String> requestedProperties = new HashSet<String>();
        for (PropertySpec ps : spec.resourceSpec.propertySpecs) {
            if (!ps.type.equals(EVENT_TYPE)) continue;
            requestedProperties.addAll(Arrays.asList(ps.propertyNames));
        }
        ManagedObjectReference contextObject = this.getContextObjectFromQuery(spec);
        for (ClientEventInfo currentEvent : clientEventInfos) {
            ArrayList<PropertyValue> resultPropertyValues = new ArrayList<PropertyValue>();
            if (requestedProperties.contains("info")) {
                PropertyValue infoPropertyValue = this.createPropertyValue("info", currentEvent);
                resultPropertyValues.add(infoPropertyValue);
            }
            if (requestedProperties.contains("taskInfoName")) {
                String taskInfoName = this.getTaskInfoName(currentEvent);
                PropertyValue taskNamePropertyValue = this.createPropertyValue("taskInfoName", taskInfoName);
                resultPropertyValues.add(taskNamePropertyValue);
            }
            if (requestedProperties.contains("contextSensitiveMessage")) {
                String message = this.getContextSensitiveMessage(currentEvent, contextObject);
                PropertyValue messagePropertyValue = this.createPropertyValue("contextSensitiveMessage", message);
                resultPropertyValues.add(messagePropertyValue);
            }
            ResultItem item = new ResultItem();
            item.properties = resultPropertyValues.toArray(new PropertyValue[resultPropertyValues.size()]);
            try {
                item.resourceObject = new URI("TODO:" + currentEvent.key + currentEvent.serverGuid);
            }
            catch (Exception ex) {
                faults.add(MixedUtil.getMethodFault((Throwable)ex));
                continue;
            }
            result.add(item);
        }
        return result;
    }

    private ManagedObjectReference getContextObjectFromQuery(QuerySpec query) {
        for (PropertySpec propertySpec : query.resourceSpec.propertySpecs) {
            if (!propertySpec.type.equals(EVENT_TYPE)) continue;
            for (ParameterSpec parameterSpec : propertySpec.parameters) {
                if (!parameterSpec.propertyName.equals("contextObject")) continue;
                return (ManagedObjectReference)parameterSpec.parameter;
            }
        }
        return null;
    }

    private String getContextSensitiveMessage(ClientEventInfo event, ManagedObjectReference contextObject) {
        if (contextObject == null) {
            if (event.eventDetail == null) {
                return event.fullFormattedMessage;
            }
            return event.eventDetail.fullFormat;
        }
        String result = "";
        ManagedObjectTypes contextObjectType = ManagedObjectTypes.getValueOf((String)contextObject.getType());
        switch (contextObjectType) {
            case VIRTUAL_MACHINE: {
                result = event.eventDetail.formatOnVm;
                break;
            }
            case HOST: {
                result = event.eventDetail.formatOnHost;
                break;
            }
            case COMPUTE_RESOURCE: {
                result = event.eventDetail.formatOnComputeResource;
                break;
            }
            case DATACENTER: {
                result = event.eventDetail.formatOnDatacenter;
                break;
            }
            case DATASTORE: {
                result = event.eventDetail.formatOnDatacenter;
                break;
            }
        }
        if (StringUtil.isNullOrEmpty((String)result)) {
            return event.eventDetail.fullFormat;
        }
        return result;
    }

    private String getTaskInfoName(ClientEventInfo event) {
        if (event.isTaskEvent.booleanValue()) {
            TaskEvent taskEvent = (TaskEvent)event.serverEvent;
            if (taskEvent.info != null) {
                return this._taskSearchHelper.getTaskDescription(taskEvent.info);
            }
        }
        return null;
    }

    private PropertyValue createPropertyValue(String propertyName, Object value) {
        PropertyValue pv = new PropertyValue();
        pv.propertyName = propertyName;
        pv.value = value;
        return pv;
    }
}

