/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.event.impl;

import com.vmware.opsmgmt.client.commons.util.ManagedObjectTypes;
import com.vmware.opsmgmt.client.event.EventDetailDescription;
import com.vmware.opsmgmt.client.event.impl.EventDescriptionCollector;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EventDescriptionPropertyProviderAdapter
implements PropertyProviderBean {
    private static final Log _logger = LogFactory.getLog(EventDescriptionPropertyProviderAdapter.class);
    private final DataService _dataService;

    public EventDescriptionPropertyProviderAdapter(DataService dataService) {
        this._dataService = dataService;
    }

    @type(value="ClusterComputeResource,ComputeResource,Datacenter,Datastore,DistributedVirtualPortgroup,DistributedVirtualSwitch,Folder,HostSystem,Network,ResourcePool,VirtualApp,VirtualMachine,StoragePod,VmwareDistributedVirtualSwitch,OpsmgmtProfileDescriptor")
    public EventDetailDescription[] getAvailableEventDescriptions(ManagedObjectReference moRef, String managedObjectType) throws Exception {
        if (_logger.isInfoEnabled()) {
            _logger.info((Object)("availableEventDescriptions property was requested for object:" + moRef + ", for type:" + managedObjectType));
        }
        String serverGuid = moRef.getServerGuid();
        EventDescriptionCollector collector = EventDescriptionCollector.getEventDetailDescriptionCollector(serverGuid, this._dataService);
        ManagedObjectTypes type2 = ManagedObjectTypes.getValueOf((String)managedObjectType);
        EventDetailDescription[] descriptions = collector.collectDetails(type2, serverGuid);
        return descriptions;
    }

    @type(value="ClusterComputeResource,ComputeResource,Datacenter,Datastore,DistributedVirtualPortgroup,DistributedVirtualSwitch,Folder,HostSystem,Network,ResourcePool,VirtualApp,VirtualMachine,StoragePod,VmwareDistributedVirtualSwitch,OpsmgmtProfileDescriptor")
    public EventDetailDescription[] getEventDescriptionByIds(ManagedObjectReference moRef, String[] eventTypeIds) throws Exception {
        if (_logger.isInfoEnabled()) {
            _logger.info((Object)("eventDescription property was requested for object:" + moRef + ", for ids:" + eventTypeIds));
        }
        if (eventTypeIds == null || eventTypeIds.length == 0) {
            throw new IllegalArgumentException("Null or empty set of ids received");
        }
        String serverGuid = moRef.getServerGuid();
        EventDescriptionCollector collector = EventDescriptionCollector.getEventDetailDescriptionCollector(serverGuid, this._dataService);
        EventDetailDescription[] descriptions = collector.collectDetails(eventTypeIds, serverGuid);
        return descriptions;
    }
}

