/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.event.impl;

import com.vmware.opsmgmt.client.event.util.Util;
import com.vmware.vim.binding.vim.event.EventFilterSpec;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.util.ArrayUtil;
import java.util.Calendar;
import java.util.Date;

public class EventFilter {
    public static int DEFAULT_MAX_COUNT = 100;
    int count;
    EventFilterSpec eventFilterSpec;
    public String serverGuid;
    int requestedPage;
    boolean migrationHistoryRequest = false;
    public ManagedObjectReference[] migrationHistoryList;
    public boolean requestingPrevPage = true;

    public EventFilter(QuerySpec query) {
        this.count = !this.requiresAllResults(query.resultSpec.maxResultCount) ? query.resultSpec.maxResultCount : DEFAULT_MAX_COUNT;
        this.eventFilterSpec = new EventFilterSpec();
        Constraint constraint = query.resourceSpec.constraint;
        if (constraint != null) {
            Constraint[] constraints;
            if (constraint instanceof PropertyConstraint) {
                constraints = new PropertyConstraint[]{(PropertyConstraint)constraint};
            } else if (constraint instanceof CompositeConstraint) {
                constraints = ((CompositeConstraint)constraint).nestedConstraints;
            } else {
                String errMsg = "Invalid query constraint for BaseEventProcessor: " + constraint.getClass().getName();
                throw new IllegalArgumentException(errMsg);
            }
            for (Constraint pc : constraints) {
                if (!(pc instanceof PropertyConstraint) || !((PropertyConstraint)pc).comparator.equals((Object)Comparator.EQUALS)) continue;
                Object targetValue = ((PropertyConstraint)pc).comparableValue;
                String propertyName = ((PropertyConstraint)pc).propertyName;
                if ("info.initiator".equals(propertyName)) {
                    if (this.eventFilterSpec.userName == null) {
                        this.eventFilterSpec.userName = new EventFilterSpec.ByUsername();
                    }
                    this.eventFilterSpec.userName = (EventFilterSpec.ByUsername)targetValue;
                    continue;
                }
                if ("info.entity".equals(propertyName)) {
                    ManagedObjectReference targetEntity;
                    if (this.eventFilterSpec.entity == null) {
                        this.eventFilterSpec.entity = new EventFilterSpec.ByEntity();
                    }
                    this.eventFilterSpec.entity.entity = targetEntity = (ManagedObjectReference)targetValue;
                    if (this.serverGuid != null) continue;
                    this.serverGuid = targetEntity.getServerGuid();
                    continue;
                }
                if ("info.recursion".equals(propertyName)) {
                    if (this.eventFilterSpec.entity == null) {
                        this.eventFilterSpec.entity = new EventFilterSpec.ByEntity();
                    }
                    String recursionType = (String)targetValue;
                    this.eventFilterSpec.entity.recursion = this.getRecursionOption(recursionType);
                    continue;
                }
                if ("info.maxResultsPerSource".equals(propertyName)) {
                    this.count = (Integer)targetValue;
                    continue;
                }
                if ("info.category".equals(propertyName)) {
                    this.eventFilterSpec.category = this.createStringArray((Object[])targetValue);
                    continue;
                }
                if ("info.systemUser".equals(propertyName)) {
                    if (this.eventFilterSpec.userName == null) {
                        this.eventFilterSpec.userName = new EventFilterSpec.ByUsername();
                    }
                    this.eventFilterSpec.userName.systemUser = (Boolean)targetValue;
                    continue;
                }
                if ("info.userList".equals(propertyName)) {
                    if (this.eventFilterSpec.userName == null) {
                        this.eventFilterSpec.userName = new EventFilterSpec.ByUsername();
                    }
                    this.eventFilterSpec.userName.userList = this.createStringArray((Object[])targetValue);
                    continue;
                }
                if ("beginTime".equals(propertyName)) {
                    if (this.eventFilterSpec.time == null) {
                        this.eventFilterSpec.time = new EventFilterSpec.ByTime();
                    }
                    Calendar beginTime = Calendar.getInstance();
                    beginTime.setTime((Date)targetValue);
                    this.eventFilterSpec.time.beginTime = beginTime;
                    continue;
                }
                if ("endTime".equals(propertyName)) {
                    if (this.eventFilterSpec.time == null) {
                        this.eventFilterSpec.time = new EventFilterSpec.ByTime();
                    }
                    Calendar endTime = Calendar.getInstance();
                    endTime.setTime((Date)targetValue);
                    this.eventFilterSpec.time.endTime = endTime;
                    continue;
                }
                if ("info.eventChainId".equals(propertyName)) {
                    if (targetValue instanceof Double) {
                        this.eventFilterSpec.eventChainId = ((Double)targetValue).intValue();
                        continue;
                    }
                    this.eventFilterSpec.eventChainId = (Integer)targetValue;
                    continue;
                }
                if ("info.serverGuid".equals(propertyName)) {
                    this.serverGuid = (String)targetValue;
                    continue;
                }
                if ("info.currentPage".equals(propertyName)) {
                    this.requestedPage = (Integer)targetValue;
                    continue;
                }
                if (propertyName.equals(Util.MIGRATION_HISTORY_LIST)) {
                    this.migrationHistoryList = this.createMORArray((Object[])targetValue);
                    continue;
                }
                if (propertyName.equals("requestingPrevPage")) {
                    this.requestingPrevPage = (Boolean)targetValue;
                    continue;
                }
                throw new IllegalArgumentException("Invalid property constraint " + propertyName);
            }
            PropertySpec[] propertySpecs = query.resourceSpec.propertySpecs;
            for (int specIndex = 0; specIndex < propertySpecs.length; ++specIndex) {
                String[] propertyNames = propertySpecs[specIndex].propertyNames;
                for (int nameIndex = 0; nameIndex < propertyNames.length; ++nameIndex) {
                    if (!propertyNames[nameIndex].equals(Util.MIGRATION_HISTORY)) continue;
                    this.eventFilterSpec.eventTypeId = new String[]{Util.VM_DEST_MIGRATION_EVENT};
                    this.migrationHistoryRequest = true;
                    return;
                }
            }
        }
    }

    private String[] createStringArray(Object[] srcArray) {
        if (ArrayUtil.isNullOrEmpty((Object[])srcArray)) {
            return null;
        }
        String[] stringArray = new String[srcArray.length];
        for (int index = 0; index < srcArray.length; ++index) {
            stringArray[index] = (String)srcArray[index];
        }
        return stringArray;
    }

    private ManagedObjectReference[] createMORArray(Object[] srcArray) {
        ManagedObjectReference[] morArray = new ManagedObjectReference[srcArray.length];
        for (int index = 0; index < srcArray.length; ++index) {
            morArray[index] = (ManagedObjectReference)srcArray[index];
        }
        return morArray;
    }

    private EventFilterSpec.RecursionOption getRecursionOption(String recursion) {
        if (recursion.equals("recursion.self")) {
            return EventFilterSpec.RecursionOption.self;
        }
        if (recursion.equals("recursion.children")) {
            return EventFilterSpec.RecursionOption.children;
        }
        return EventFilterSpec.RecursionOption.all;
    }

    private boolean requiresAllResults(Integer maxResultCount) {
        return maxResultCount == null || maxResultCount == -1;
    }
}

