/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.event.impl;

import com.vmware.opsmgmt.client.event.impl.EventBuilder;
import com.vmware.opsmgmt.client.event.impl.EventDescriptionCollector;
import com.vmware.opsmgmt.client.event.impl.EventWrapper;
import com.vmware.vim.binding.vim.event.Event;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vise.core.model.event.ClientEventInfo;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.mixed.ManagedEntityParentLocator;
import com.vmware.vsphere.client.mixed.MixedServiceUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EventsTransformer {
    private static final ClientEventInfo[] EMPTY_CLIENT_EVENT_INFO_ARR = new ClientEventInfo[0];
    private static final Object[] EMPTY_OBJECT_ARR = new Object[0];

    public static ClientEventInfo[] transformToClientEvents(DataService dataService, Event[] serverEvents, String serverGuid, ManagedEntityParentLocator parentLocator, List<MethodFault> allFaults) throws Exception {
        if (serverEvents.length == 0) {
            return EMPTY_CLIENT_EVENT_INFO_ARR;
        }
        EventDescriptionCollector collector = EventDescriptionCollector.getEventDetailDescriptionCollector(serverGuid, dataService);
        ArrayList<EventWrapper> eventWrappers = new ArrayList<EventWrapper>();
        HashSet<ManagedObjectReference> extractedMoRefs = new HashSet<ManagedObjectReference>();
        for (Event serverEvent : serverEvents) {
            EventWrapper eventWrapper = new EventWrapper(serverEvent, collector, serverGuid);
            eventWrappers.add(eventWrapper);
            extractedMoRefs.addAll(eventWrapper.getMoRefs());
        }
        ManagedObjectReference[] moRefs = extractedMoRefs.toArray(ManagedObjectUtil.EMPTY_MANAGED_OBJECT_ARR);
        Map dvsMap = MixedServiceUtil.getDvsLookups((DataService)dataService, (ManagedObjectReference[])moRefs);
        moRefs = MixedServiceUtil.replaceDvsEntries((ManagedObjectReference[])moRefs, (Map)dvsMap);
        Map parentInfos = parentLocator.locateCustomParents(moRefs);
        ArrayList<ClientEventInfo> clientEvents = new ArrayList<ClientEventInfo>(eventWrappers.size());
        EventBuilder builder = new EventBuilder(parentLocator, parentInfos, dvsMap, allFaults);
        for (EventWrapper eventWrapper : eventWrappers) {
            clientEvents.add(builder.build(eventWrapper, serverGuid));
        }
        Set<ManagedObjectReference> removedEntities = builder.getRemovedEntities();
        if (!removedEntities.isEmpty()) {
            for (ClientEventInfo clientEvent : clientEvents) {
                HashSet eventEntities = new HashSet();
                Collections.addAll(eventEntities, clientEvent.existingEntities);
                eventEntities.removeAll(removedEntities);
                clientEvent.existingEntities = eventEntities.toArray(EMPTY_OBJECT_ARR);
            }
        }
        Set<ManagedObjectReference> set = builder.getUniqueTargets();
        set.toArray(ManagedObjectUtil.EMPTY_MANAGED_OBJECT_ARR);
        return clientEvents.toArray(EMPTY_CLIENT_EVENT_INFO_ARR);
    }
}

