/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.actionsfw.impl;

import com.vmware.vim.binding.vim.VirtualApp;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vise.actionsfw.Action;
import com.vmware.vise.actionsfw.ActionContext;
import com.vmware.vise.actionsfw.ActionEvaluation;
import com.vmware.vise.actionsfw.ActionSpec;
import com.vmware.vise.actionsfw.EvaluationStatus;
import com.vmware.vise.actionsfw.impl.ActionEvaluationImpl;
import com.vmware.vise.actionsfw.impl.ActionsServiceUtil;
import com.vmware.vise.actionsfw.impl.EvaluationStatusImpl;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.util.PropertyValueMap;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.i18n.ResourceUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class ActionImpl
implements Action {
    private static final Log _logger = LogFactory.getLog(ActionImpl.class);
    private static final String DEFAULT_BUNDLE = "actionsService";
    private static final String PRIVILAGES_PROPERTY = "grantedPrivileges";
    public static final String DISABLED_OPERATIONS = "disabledOperations";
    static final String VM_MANAGED_BY_KEY_PROP = "config/managedBy/extensionKey";
    static final String VAPP_MANAGED_BY_KEY_PROP = "vAppConfig/managedBy/extensionKey";
    static final String RESULT_MANAGED_BY_KEY_PROP = "managedByExtensionKey";
    private final ActionSpec _spec;
    private final ObjectReferenceService _objRefService;
    private final List<String> _applicableTargetTypes;

    ActionImpl(ActionSpec spec, List<String> targetTypes, ObjectReferenceService objRefService) {
        String nullPointerMessage = null;
        if (spec == null) {
            nullPointerMessage = "ActionSpec must not be null";
        } else if (StringUtil.isNullOrWhitespace((String)spec.getUid())) {
            nullPointerMessage = "ActionSpec.getUid() must not be null or empty";
        }
        if (nullPointerMessage != null) {
            throw new NullPointerException(nullPointerMessage);
        }
        this._spec = spec;
        this._objRefService = objRefService;
        this._applicableTargetTypes = targetTypes;
        if (this.getLabel() == null && this.getIcon() == null) {
            _logger.warn((Object)("Action " + this.getUid() + " has no visual representation."));
        }
        if (this.getInvoker() == null) {
            _logger.warn((Object)("Action " + this.getUid() + " is a no-op as it does not specify an invoker."));
        }
    }

    public String getUid() {
        return this._spec.getUid();
    }

    public void setUid(String uid) {
    }

    @Override
    public String getLabel() {
        return StringUtil.returnNullIfEmpty((String)this._spec.label);
    }

    @Override
    public String getDescription() {
        return StringUtil.returnNullIfEmpty((String)this._spec.description);
    }

    @Override
    public String getIcon() {
        return StringUtil.returnNullIfEmpty((String)this._spec.icon);
    }

    @Override
    public String getConfirmationTitle() {
        return this._spec.confirmationTitle;
    }

    @Override
    public String getConfirmationText() {
        return this._spec.confirmationText;
    }

    @Override
    public String getConfirmationTextNone() {
        return this._spec.confirmationTextNone;
    }

    @Override
    public String getConfirmationTextSome() {
        return this._spec.confirmationTextSome;
    }

    @Override
    public String getConfirmationTextAll() {
        return this._spec.confirmationTextAll;
    }

    @Override
    public List<String> getApplicableTargetTypes() {
        return this._applicableTargetTypes;
    }

    boolean evaluateApplicability(ActionContext context) {
        if (context == null) {
            throw new NullPointerException("context must not be null");
        }
        List<Object> targets = context.getTargetObjects();
        if (ArrayUtil.isNullOrEmpty(targets)) {
            return this.getApplicableTargetTypes().size() == 0;
        }
        if (targets.size() > 1 && !this.acceptsMultipleTargets()) {
            return false;
        }
        String targetType = null;
        for (Object target : targets) {
            String nextType = ActionsServiceUtil.getTargetType(target, this._objRefService);
            if (!(targetType == null || targetType.equals(nextType) || this.acceptsHeterogeneousTargets() && this.applicableToType(nextType))) {
                return false;
            }
            targetType = nextType;
        }
        return this.applicableToType(targetType);
    }

    ActionEvaluation evaluateAvailability(ActionContext context, PropertyValueMap data) {
        ActionEvaluationImpl evaluation = new ActionEvaluationImpl(this, context);
        evaluation.available = false;
        if (!ArrayUtil.isNullOrEmpty(context.getTargetObjects())) {
            evaluation.evaluationStatusMap = new HashMap<String, EvaluationStatus>();
            for (Object target : context.getTargetObjects()) {
                EvaluationStatus status = this.evaluateAvailability(target, data);
                evaluation.evaluationStatusMap.put(this._objRefService.getUid(target), status);
                if (!status.isAvailable()) continue;
                evaluation.available = true;
                evaluation.additionalProperties = this.getAdditionalProperties(target, data, evaluation.additionalProperties);
            }
        } else {
            evaluation.available = true;
        }
        evaluation.timestamp = new Date();
        evaluation.invoker = this._spec.invoker;
        if (evaluation.isAvailable()) {
            evaluation.additionalData = this._spec.additionalData;
            evaluation.pluginData = this._spec.pluginData;
            evaluation.remotePluginExtensionContext = this._spec.remotePluginExtensionContext;
        }
        return evaluation;
    }

    List<String> getPropsNeededForEvaluation() {
        HashSet<String> propsToFetch = new HashSet<String>();
        if (this.getAvailabilityProperty() != null) {
            propsToFetch.add(this.getAvailabilityProperty());
        }
        if (this.getRequiredPrivileges() != null) {
            propsToFetch.add(PRIVILAGES_PROPERTY);
        }
        return new ArrayList<String>(propsToFetch);
    }

    String[] getOperationIds() {
        if (StringUtil.isNullOrWhitespace((String)this._spec.operationIds)) {
            return null;
        }
        return StringUtil.splitAndTrim((String)this._spec.operationIds, (String)",");
    }

    boolean acceptsMultipleTargets() {
        return this._spec.acceptsMultipleTargets;
    }

    boolean acceptsHeterogeneousTargets() {
        return this._spec.acceptsHeterogeneousTargets;
    }

    boolean isPrivateAction() {
        return this._spec.privateAction;
    }

    private EvaluationStatus evaluateAvailability(Object target, PropertyValueMap data) {
        EvaluationStatusImpl evalStatus = new EvaluationStatusImpl();
        evalStatus.available = true;
        if (!this.checkPrivileges(target, data)) {
            evalStatus.available = false;
            evalStatus.messages.add(ResourceUtil.getString((String)DEFAULT_BUNDLE, (String)"actionsService.notAvailable.privilege"));
        }
        if (!this.checkDisabledOperations(target, data)) {
            evalStatus.available = false;
            evalStatus.messages.add(ResourceUtil.getString((String)DEFAULT_BUNDLE, (String)"actionsService.notAvailable.state"));
        }
        if (!this.checkAvailableProperty(target, data)) {
            evalStatus.available = false;
            if (this.getNotAvailableText() != null) {
                evalStatus.messages.add(this.getNotAvailableText());
            }
        }
        return evalStatus;
    }

    private boolean checkPrivileges(Object target, PropertyValueMap data) {
        if (this.getRequiredPrivileges() == null) {
            return true;
        }
        try {
            String[] privileges = ActionsServiceUtil.extractStringArrayProperty(target, PRIVILAGES_PROPERTY, this._objRefService, data);
            return ActionsServiceUtil.isPrivilegeGranted(this.getRequiredPrivileges(), privileges);
        }
        catch (Exception ex) {
            _logger.error((Object)("Error evaluating action " + this.getUid()), (Throwable)ex);
            return true;
        }
    }

    private boolean checkDisabledOperations(Object target, PropertyValueMap data) {
        if (this.getOperationIds() == null) {
            return true;
        }
        try {
            String[] disabledOps = ActionsServiceUtil.extractStringArrayProperty(target, DISABLED_OPERATIONS, this._objRefService, data);
            return ActionsServiceUtil.isOperationAllowed(this.getOperationIds(), disabledOps);
        }
        catch (Exception ex) {
            _logger.error((Object)("Error evaluating action " + this.getUid()), (Throwable)ex);
            return true;
        }
    }

    private boolean checkAvailableProperty(Object target, PropertyValueMap data) {
        String propName = this.getAvailabilityProperty();
        if (propName == null) {
            return true;
        }
        String uid = this._objRefService.getUid(target);
        PropertyValue pv = data.getProperty(uid, propName);
        BooleanSupplier booleanSupplier = new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                return ActionImpl.this.isAvailabilityPropertyNegated();
            }
        };
        boolean propValue = ActionsServiceUtil.extractBooleanProperty(pv, propName, uid, booleanSupplier);
        return propValue;
    }

    private String getAvailabilityProperty() {
        String availabilityProperty = StringUtil.returnNullIfEmpty((String)this._spec.availabilityProperty);
        if (availabilityProperty == null) {
            return null;
        }
        if (availabilityProperty.startsWith("!")) {
            availabilityProperty = availabilityProperty.substring(1);
            availabilityProperty = availabilityProperty.trim();
        }
        return availabilityProperty;
    }

    private boolean isAvailabilityPropertyNegated() {
        String availabilityProperty = StringUtil.returnNullIfEmpty((String)this._spec.availabilityProperty);
        return availabilityProperty != null && availabilityProperty.startsWith("!");
    }

    private String getNotAvailableText() {
        return StringUtil.returnNullIfEmpty((String)this._spec.notAvailableText);
    }

    private String[] getRequiredPrivileges() {
        if (StringUtil.isNullOrWhitespace((String)this._spec.requiredPrivileges)) {
            return null;
        }
        return StringUtil.splitAndTrim((String)this._spec.requiredPrivileges, (String)",");
    }

    private boolean applicableToType(String type) {
        boolean isGlobal = this.getApplicableTargetTypes().size() == 0;
        boolean isApplicable = isGlobal && !this.isPrivateAction() || this.getApplicableTargetTypes().contains(type);
        return isApplicable;
    }

    private Map<String, Object> getAdditionalProperties(Object target, PropertyValueMap data, Map<String, Object> additionalProperties) {
        String objectType = this._objRefService.getResourceObjectType(target);
        String managedByProperty = "";
        if (objectType.equals(VirtualMachine.class.getSimpleName())) {
            managedByProperty = VM_MANAGED_BY_KEY_PROP;
        }
        if (objectType.equals(VirtualApp.class.getSimpleName())) {
            managedByProperty = VAPP_MANAGED_BY_KEY_PROP;
        }
        if (!managedByProperty.isEmpty()) {
            if (additionalProperties != null && additionalProperties.get(RESULT_MANAGED_BY_KEY_PROP) != null) {
                return additionalProperties;
            }
            String uid = this._objRefService.getUid(target);
            PropertyValue pv = data.getProperty(uid, managedByProperty);
            if (pv != null && pv.value != null) {
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put(RESULT_MANAGED_BY_KEY_PROP, pv.value);
                return result;
            }
        }
        return additionalProperties;
    }

    private String getInvoker() {
        return StringUtil.returnNullIfEmpty((String)this._spec.invoker);
    }

    public static interface NegatedPropertyResolver {
        public boolean getAsBoolean();
    }
}

