/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.advancedsettings;

import com.vmware.vim.binding.vim.ElementDescription;
import com.vmware.vim.binding.vim.option.ChoiceOption;
import com.vmware.vim.binding.vim.option.FloatOption;
import com.vmware.vim.binding.vim.option.IntOption;
import com.vmware.vim.binding.vim.option.LongOption;
import com.vmware.vim.binding.vim.option.OptionDef;
import com.vmware.vise.data.common.XSFacet;
import com.vmware.vise.data.common.XSFacetType;

public class AdvancedSettingsStaticValueSpaceUtil {
    public static XSFacet[] createFromOptionDef(OptionDef optionDef) {
        XSFacet[] valueSpace = null;
        if (optionDef.optionType instanceof ChoiceOption) {
            ChoiceOption option = (ChoiceOption)optionDef.optionType;
            valueSpace = AdvancedSettingsStaticValueSpaceUtil.createEnumeration(option);
        } else if (optionDef.optionType instanceof IntOption) {
            IntOption option = (IntOption)optionDef.optionType;
            valueSpace = AdvancedSettingsStaticValueSpaceUtil.createNumericBounds(option.min, option.max);
        } else if (optionDef.optionType instanceof LongOption) {
            LongOption option = (LongOption)optionDef.optionType;
            valueSpace = AdvancedSettingsStaticValueSpaceUtil.createNumericBounds(option.min, option.max);
        } else if (optionDef.optionType instanceof FloatOption) {
            FloatOption option = (FloatOption)optionDef.optionType;
            valueSpace = AdvancedSettingsStaticValueSpaceUtil.createNumericBounds(Float.valueOf(option.min), Float.valueOf(option.max));
        }
        return valueSpace;
    }

    private static XSFacet[] createNumericBounds(Number lowerBoundValue, Number upperBoundValue) {
        XSFacet lowerBound = AdvancedSettingsStaticValueSpaceUtil.createNumericLowerBound(lowerBoundValue);
        XSFacet upperBound = AdvancedSettingsStaticValueSpaceUtil.createNumericUpperBound(upperBoundValue);
        XSFacet[] valueSpace = new XSFacet[]{lowerBound, upperBound};
        return valueSpace;
    }

    private static <T extends Number> XSFacet createNumericLowerBound(T lowerBoundValue) {
        XSFacet lowerBound = new XSFacet();
        lowerBound.type = XSFacetType.MININCLUSIVE;
        lowerBound.value = lowerBoundValue;
        return lowerBound;
    }

    private static <T extends Number> XSFacet createNumericUpperBound(T upperBoundValue) {
        XSFacet upperBound = new XSFacet();
        upperBound.type = XSFacetType.MAXINCLUSIVE;
        upperBound.value = upperBoundValue;
        return upperBound;
    }

    private static XSFacet[] createEnumeration(ChoiceOption choiceOption) {
        XSFacet[] valueSpace = new XSFacet[choiceOption.choiceInfo.length];
        int index = 0;
        for (ElementDescription element : choiceOption.choiceInfo) {
            XSFacet facet;
            valueSpace[index] = facet = AdvancedSettingsStaticValueSpaceUtil.createEnumerationField(element.key);
            ++index;
        }
        return valueSpace;
    }

    private static XSFacet createEnumerationField(String value) {
        XSFacet enumField = new XSFacet();
        enumField.type = XSFacetType.ENUMERATION;
        enumField.value = value;
        return enumField;
    }
}

