/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.data.util;

import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.DerivedPropertyInfo;
import com.vmware.vise.data.query.DerivedPropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class DerivedPropertyProviderAdapterBase
implements DerivedPropertyProviderAdapter {
    private Map<String, DerivedPropertyComputation> _derivedPropertyMap;
    private final DataServiceExtensionRegistry _extensionRegistry;

    public DerivedPropertyProviderAdapterBase(DataServiceExtensionRegistry dser) {
        this._extensionRegistry = dser;
    }

    public ResultSet getProperties(PropertyRequestSpec propertyRequest) {
        ResultSet result = new ResultSet();
        Object[] objects = propertyRequest.objects;
        PropertySpec[] propertySpecs = propertyRequest.properties;
        Map valsByObject = propertyRequest.derivedPropertyData.getSourcePropertyValuesByObject();
        HashSet<String> requestedPropertyNames = new HashSet<String>();
        for (PropertySpec ps : propertySpecs) {
            requestedPropertyNames.addAll(Arrays.asList(ps.propertyNames));
        }
        ResultItem[] resultItems = new ResultItem[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            Object currentObject = objects[i];
            Map sourceValuesMap = (Map)valsByObject.get(currentObject);
            resultItems[i] = this.getResultItem(currentObject, requestedPropertyNames, sourceValuesMap);
        }
        result.totalMatchedObjectCount = objects.length;
        result.items = resultItems;
        return result;
    }

    public void initialize() {
        CompleteDerivedPropertyInfo[] in = this.getDerivedPropertyInfos();
        assert (in != null && in.length > 0);
        this._derivedPropertyMap = new HashMap<String, DerivedPropertyComputation>();
        DerivedPropertyInfo[] derivedPropertyInfos = new DerivedPropertyInfo[in.length];
        String[] properties = new String[in.length];
        for (int i = 0; i < in.length; ++i) {
            derivedPropertyInfos[i] = in[i].derivedPropertyInfo();
            properties[i] = in[i].propertyName;
            this._derivedPropertyMap.put(in[i].propertyName, in[i].computation);
        }
        TypeInfo ti = new TypeInfo();
        ti.type = this.getType();
        ti.properties = properties;
        ti.derivedProperties = derivedPropertyInfos;
        this._extensionRegistry.registerDataAdapter((PropertyProviderAdapter)this, new TypeInfo[]{ti});
    }

    protected abstract CompleteDerivedPropertyInfo[] getDerivedPropertyInfos();

    protected abstract String getType();

    private ResultItem getResultItem(Object sourceObject, Set<String> requestedPropertyNames, Map<String, Object> sourceValuesMap) {
        assert (requestedPropertyNames != null);
        ResultItem result = new ResultItem();
        result.resourceObject = sourceObject;
        PropertyValue[] propVals = new PropertyValue[requestedPropertyNames.size()];
        int i = 0;
        for (String propertyName : requestedPropertyNames) {
            DerivedPropertyComputation c = this._derivedPropertyMap.get(propertyName);
            assert (c != null) : "Received request for unknown property: " + propertyName;
            propVals[i++] = DerivedPropertyProviderAdapterBase.propertyValue(sourceObject, propertyName, c.compute(sourceValuesMap));
        }
        result.properties = propVals;
        return result;
    }

    protected static <T> T getPropertyValue(Map<String, Object> propertyValuesMap, String propertyName) {
        return (T)propertyValuesMap.get(propertyName);
    }

    private static PropertyValue propertyValue(Object resourceObject, String propertyName, Object val) {
        PropertyValue result = new PropertyValue();
        result.propertyName = propertyName;
        result.resourceObject = resourceObject;
        result.value = val;
        return result;
    }

    protected static class CompleteDerivedPropertyInfo {
        final String propertyName;
        final String[] sourceProperties;
        final DerivedPropertyComputation computation;

        public CompleteDerivedPropertyInfo(String propertyName, String[] sourceProperties, DerivedPropertyComputation computation) {
            this.propertyName = propertyName;
            this.sourceProperties = sourceProperties;
            this.computation = computation;
        }

        DerivedPropertyInfo derivedPropertyInfo() {
            DerivedPropertyInfo result = new DerivedPropertyInfo();
            result.propertyName = this.propertyName;
            result.sourcePropertyNames = this.sourceProperties;
            return result;
        }
    }

    protected static interface DerivedPropertyComputation {
        public Object compute(Map<String, Object> var1);
    }
}

