/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.drs.util;

import com.vmware.vim.binding.impl.vmodl.KeyAnyValueImpl;
import com.vmware.vim.binding.vim.event.Event;
import com.vmware.vim.binding.vim.event.EventEx;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vise.vim.commons.i18n.LocalizationUtil;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FaultsLocalizationUtil {
    private static final Pattern tokenPattern = Pattern.compile("\\{(?<token>.*?)(\\}|(\\.@))");
    private static final String DEFAULT_ARGUMENT_VALUE = "";
    private static final Log _logger = LogFactory.getLog(FaultsLocalizationUtil.class);

    public static String getDrsFaultMessage(Exception fault) {
        return FaultsLocalizationUtil.getLocalizedMessage(fault, "summary");
    }

    public static String getHAIssueMessage(Event event) {
        return FaultsLocalizationUtil.getLocalizedMessage(event, "fullFormat");
    }

    private static String getLocalizedMessage(Object issue, String keyPostfix) {
        String type;
        KeyAnyValue[] extendedEventArgs = null;
        if (issue instanceof EventEx) {
            EventEx extendedEvent = (EventEx)issue;
            type = extendedEvent.eventTypeId;
            if (extendedEvent.arguments != null) {
                extendedEventArgs = extendedEvent.arguments;
            }
        } else {
            type = issue.getClass().getSimpleName();
        }
        String localizationKey = String.format("%s.%s", type, keyPostfix);
        String tokenizedMessage = LocalizationUtil.getLocalizedMessage((String)localizationKey);
        if (tokenizedMessage == null) {
            return DEFAULT_ARGUMENT_VALUE;
        }
        KeyAnyValue[] keysAndValues = FaultsLocalizationUtil.extractKeys(tokenizedMessage);
        if (keysAndValues != null && keysAndValues.length == 0) {
            return tokenizedMessage;
        }
        for (KeyAnyValue entry : keysAndValues) {
            boolean isValueResolved = false;
            if (extendedEventArgs != null) {
                for (KeyAnyValue extendedArg : extendedEventArgs) {
                    if (!extendedArg.getKey().equals(entry.getKey())) continue;
                    entry.setValue(extendedArg.getValue());
                    isValueResolved = true;
                    break;
                }
            }
            if (isValueResolved) continue;
            String propertyChain = entry.getKey();
            try {
                String[] propertyPath = propertyChain.split("\\.");
                Object propertyValue = issue;
                for (String propertyName : propertyPath) {
                    if (propertyValue == null) break;
                    PropertyDescriptor descriptor = new PropertyDescriptor(propertyName, propertyValue.getClass());
                    Method getter = descriptor.getReadMethod();
                    if (getter == null) continue;
                    propertyValue = getter.invoke(propertyValue, new Object[0]);
                }
                if (propertyValue instanceof String[]) {
                    propertyValue = StringUtils.join((Object[])((String[])propertyValue), (String)LocalizationUtil.getLocalizedMessage((String)"issueArgument.delimiter"));
                }
                if (propertyValue == null) continue;
                entry.setValue(propertyValue);
            }
            catch (IntrospectionException | IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                String errorMessage = String.format("Failed to get value for: %s in: %s", propertyChain, type);
                _logger.error((Object)errorMessage, (Throwable)ex);
            }
        }
        String localizedMessage = LocalizationUtil.getLocalizedMessage((String)localizationKey, (KeyAnyValue[])keysAndValues);
        return localizedMessage;
    }

    private static KeyAnyValue[] extractKeys(String tokenizedMessage) {
        Matcher matcher = tokenPattern.matcher(tokenizedMessage);
        ArrayList<KeyAnyValueImpl> keysAndValues = new ArrayList<KeyAnyValueImpl>();
        while (matcher.find()) {
            KeyAnyValueImpl keyAnyValue = new KeyAnyValueImpl();
            keyAnyValue.setKey(matcher.group("token"));
            keyAnyValue.setValue((Object)DEFAULT_ARGUMENT_VALUE);
            keysAndValues.add(keyAnyValue);
        }
        return keysAndValues.toArray(new KeyAnyValue[0]);
    }
}

