/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.ippool.util;

import com.vmware.vim.binding.vim.IpPoolManager;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vim.vApp.IpPool;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.ippool.vapp.VAppIpPoolData;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IpPoolUtil {
    private static final Log _logger = LogFactory.getLog(IpPoolUtil.class);

    public static VAppIpPoolData getIpPoolData(ManagedObjectReference[] networks, DataService dataService) throws Exception {
        VAppIpPoolData result = new VAppIpPoolData();
        if (networks == null) {
            return result;
        }
        result.dhcpV4Present = true;
        result.dhcpV6Present = true;
        result.ipV4RangePresent = true;
        result.ipV6RangePresent = true;
        for (ManagedObjectReference network : networks) {
            String networkName = IpPoolUtil.getStringProperty(dataService, network, "name");
            IpPool pool = IpPoolUtil.getIpPool(network, dataService);
            result.ipPoolMap.put(networkName, pool);
            if (pool == null) {
                result.dhcpV4Present = false;
                result.dhcpV6Present = false;
                result.ipV4RangePresent = false;
                result.ipV6RangePresent = false;
                continue;
            }
            IpPool.IpPoolConfigInfo ipv4Config = pool.ipv4Config;
            IpPool.IpPoolConfigInfo ipv6Config = pool.ipv6Config;
            if (ipv4Config == null || ipv4Config.dhcpServerAvailable == null || !ipv4Config.dhcpServerAvailable.booleanValue()) {
                result.dhcpV4Present = false;
            }
            if (ipv6Config == null || ipv6Config.dhcpServerAvailable == null || !ipv6Config.dhcpServerAvailable.booleanValue()) {
                result.dhcpV6Present = false;
            }
            if (ipv4Config == null || ipv4Config.ipPoolEnabled == null || !ipv4Config.ipPoolEnabled.booleanValue()) {
                result.ipV4RangePresent = false;
            }
            if (ipv6Config != null && ipv6Config.ipPoolEnabled != null && ipv6Config.ipPoolEnabled.booleanValue()) continue;
            result.ipV6RangePresent = false;
        }
        return result;
    }

    public static IpPool getIpPool(ManagedObjectReference network, DataService dataService) throws Exception {
        ManagedObjectReference datacenterRef;
        String poolName = IpPoolUtil.getStringProperty(dataService, network, "summary.ipPoolName");
        if (poolName == null || poolName.isEmpty()) {
            return null;
        }
        String serviceGuid = network.getServerGuid();
        VcService vcService = VimSessionUtil.getService((String)serviceGuid);
        ServiceInstanceContent content = vcService.getServiceInstanceContent();
        ManagedObjectReference managerRef = content.getIpPoolManager();
        IpPoolManager manager = (IpPoolManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)managerRef);
        IpPool[] pools = manager.queryIpPools(datacenterRef = IpPoolUtil.getDatacenter(network, dataService));
        if (pools == null) {
            _logger.error((Object)("IP pool: " + poolName + " not found in the datacenter: " + datacenterRef));
            return null;
        }
        for (IpPool pool : pools) {
            if (!pool.name.equals(poolName)) continue;
            return pool;
        }
        return null;
    }

    private static String getStringProperty(DataService dataService, ManagedObjectReference moRef, String property) throws MethodFault {
        try {
            Object result = QueryUtil.getProperty((DataService)dataService, (Object)moRef, (String)property);
            if (result instanceof String) {
                return (String)result;
            }
            throw MixedUtil.getInvalidEntityFault();
        }
        catch (Exception e) {
            throw MixedUtil.getMethodFault((Throwable)e);
        }
    }

    private static ManagedObjectReference getDatacenter(ManagedObjectReference network, DataService dataService) throws MethodFault {
        try {
            Object result = QueryUtil.getProperty((DataService)dataService, (Object)network, (String)"dc");
            if (result instanceof ManagedObjectReference) {
                return (ManagedObjectReference)result;
            }
            throw MixedUtil.getInvalidEntityFault();
        }
        catch (Exception e) {
            throw MixedUtil.getMethodFault((Throwable)e);
        }
    }
}

