/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.provisioning.ovf;

import com.vmware.vapi.bindings.DynamicStructure;
import com.vmware.vapi.bindings.DynamicStructureImpl;
import com.vmware.vapi.bindings.Structure;
import com.vmware.vcenter.ovf.OvfParams;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class OvfParametersUtil {
    public static List<Structure> convertToStaticStructureParams(List<Structure> dynamicStructureParameters, Set<Class<? extends Structure>> staticStructureTypes) {
        ArrayList<Structure> staticTypeParameters = new ArrayList<Structure>();
        for (Class<? extends Structure> paramType : staticStructureTypes) {
            Structure param = OvfParametersUtil.getOvfParameter(dynamicStructureParameters, paramType);
            if (param == null) continue;
            staticTypeParameters.add(param);
        }
        return staticTypeParameters;
    }

    public static List<Structure> convertToDynamicStructureParams(List<Structure> staticStructureParameters) {
        ArrayList<Structure> dynamicStructureParameters = new ArrayList<Structure>();
        if (staticStructureParameters == null) {
            return dynamicStructureParameters;
        }
        for (Structure staticStructure : staticStructureParameters) {
            DynamicStructure dynamicStructure = OvfParametersUtil.toDynamicStructure(staticStructure);
            dynamicStructureParameters.add((Structure)dynamicStructure);
        }
        return dynamicStructureParameters;
    }

    public static DynamicStructure toDynamicStructure(Structure staticStructure) {
        return new DynamicStructureImpl(staticStructure._getDataValue());
    }

    private static <P extends Structure> P getOvfParameter(List<Structure> params, Class<P> paramClass) {
        if (params == null) {
            return null;
        }
        String type = paramClass.getSimpleName();
        for (Structure s : params) {
            OvfParams param = (OvfParams)s._convertTo(OvfParams.class);
            if (!type.equals(param.getType())) continue;
            return (P)s._convertTo(paramClass);
        }
        return null;
    }
}

