/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.util.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CollectionUtil {
    public static <T, U> U getObjectByType(T[] array, Class<? extends U> objectType) {
        if (array == null || objectType == null) {
            return null;
        }
        for (T obj : array) {
            if (obj == null || !obj.getClass().equals(objectType)) continue;
            return objectType.cast(obj);
        }
        return null;
    }

    public static <T> T getObjectByType(List<Object> list, Class<T> clazz) {
        if (list == null || clazz == null) {
            return null;
        }
        for (Object obj : list) {
            if (!clazz.isInstance(obj)) continue;
            return clazz.cast(obj);
        }
        return null;
    }

    public static Set<Class<?>> getObjectTypes(Collection<Object> objects) {
        if (objects == null || objects.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet result = new HashSet();
        for (Object obj : objects) {
            if (obj == null) continue;
            result.add(obj.getClass());
        }
        return result;
    }

    public static <T> List<T> toSafeList(List<T> collection) {
        if (collection != null) {
            return collection;
        }
        ArrayList result = new ArrayList();
        return result;
    }
}

