/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.library.impl;

import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.model.PropertyProvider;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.content.LibraryModel;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.commands.DataFetchCommand;
import com.vmware.vise.data.query.type;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vsphere.client.library.data.SubscribedLibraryData;
import com.vmware.vsphere.client.library.model.LibraryDataModel;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.Validate;

public class LibraryPropertyProvider
implements PropertyProviderBean {
    private static final String CONTENTLIBRARY_DELETELOCALLIBRARY = "ContentLibrary.DeleteLocalLibrary";
    private static final String CONTENTLIBRARY_DELETESUBSCRIBEDLIBRARY = "ContentLibrary.DeleteSubscribedLibrary";
    private static final String LIBRARY_MODEL = "com.vmware.content.LibraryModel";
    private static final String LIBRARY_TYPE_PROP = "com.vmware.content.LibraryModel/type";
    private static final String LIBRARY_SERVERGUID_PROP = "com.vmware.content.LibraryModel/serverGuid";
    private static final String LIBRARY_SERVERGUID_PROP2 = "serverGuid";
    private static final String LIBRARY_ISPUBLISHED_PROP = "com.vmware.content.LibraryModel/publishInfo/published";
    private static final String NAME_PROP = "name";
    private static final String DESCRIPTION_PROP = "description";
    private static final String CREATION_TIME_PROP = "creationTime";
    private static final String SUBSCRIPTION_URL_PROP = "com.vmware.content.LibraryModel/subscriptionInfo/subscriptionUrl";
    private static final String SOURCE_LIB_PROP = "subscriptionInfo/sourceInfo/sourceLibrary";
    private static final String STORAGE_BACKINGS = "com.vmware.content.LibraryModel/storageBackings";
    private static final String SYNC_TIME_FORMATED_PROP = "lastSyncTime.@formatted";
    private final DataFetchCommand _dataFetchCommand;
    private final DataService _dataService;
    private QueryService _queryService;

    public LibraryPropertyProvider(DataFetchCommand dataFetchCommand, DataService dataService, QueryServiceFactory queryServiceFactory) {
        Validate.notNull((Object)dataFetchCommand, (String)"dataFetchCommand is null");
        Validate.notNull((Object)dataService, (String)"dataService is null");
        this._dataFetchCommand = dataFetchCommand;
        this._dataService = dataService;
        this._queryService = queryServiceFactory.getQueryService();
    }

    @type(value="com.vmware.content.Library")
    public Boolean getIsParentVCCompatibleForImport(URI libraryUri) throws Exception {
        Validate.notNull((Object)libraryUri, (String)"libraryUri is null during isParentVCCompatibleForImport");
        String serverGuid = (String)QueryUtil.getProperty((DataService)this._dataService, (Object)libraryUri, (String)LIBRARY_SERVERGUID_PROP2);
        return VcServiceUtil.is65VcOrLaterByServerGuid((String)serverGuid);
    }

    @type(value="com.vmware.content.Library")
    public Boolean getHasDeletePrivileges(URI libraryUri) throws Exception {
        Validate.notNull((Object)libraryUri, (String)"libraryUri is null.");
        String[] grantedPrivileges = (String[])QueryUtil.getProperty((DataService)this._dataService, (Object)libraryUri, (String)"grantedPrivileges");
        List<String> privilegesList = Arrays.asList(grantedPrivileges);
        Object[] libraryUriArray = new URI[]{libraryUri};
        Collection libraryData = this._dataFetchCommand.execute(LibraryDataModel.class, libraryUriArray);
        if (libraryData != null && libraryData.size() > 0 && privilegesList != null) {
            LibraryDataModel library = (LibraryDataModel)((Object)libraryData.iterator().next());
            if (LibraryModel.LibraryType.LOCAL.toString().equals(library.type)) {
                return privilegesList.contains(CONTENTLIBRARY_DELETELOCALLIBRARY);
            }
            return privilegesList.contains(CONTENTLIBRARY_DELETESUBSCRIBEDLIBRARY);
        }
        return true;
    }

    @type(value="VirtualApp, VirtualMachine, Folder")
    public Collection<LibraryModel> getTargetLibraries(ManagedObjectReference objRef) {
        ResultSet librariesResult = this._queryService.select(new String[]{"@modelKey", NAME_PROP, DESCRIPTION_PROP, CREATION_TIME_PROP}).from(new String[]{LIBRARY_MODEL}).where(LogicalOperator.AND, new PropertyPredicate[]{new PropertyPredicate(LIBRARY_TYPE_PROP, PropertyPredicate.ComparisonOperator.EQUAL, (Object)LibraryModel.LibraryType.LOCAL), new PropertyPredicate(LIBRARY_SERVERGUID_PROP, PropertyPredicate.ComparisonOperator.EQUAL, (Object)objRef.getServerGuid())}).fetch();
        return this.getLibraryObjectsFromResult(librariesResult.getItems());
    }

    @type(value="VirtualMachine, Folder")
    @PropertyProvider(value="VirtualMachine/localUnpublishedTargetLibraries")
    public Collection<LibraryModel> getLocalUnpublishedTargetLibraries(ManagedObjectReference objRef) {
        ResultSet librariesResult = this._queryService.select(new String[]{"@modelKey", NAME_PROP, DESCRIPTION_PROP, CREATION_TIME_PROP}).from(new String[]{LIBRARY_MODEL}).where(LogicalOperator.AND, Arrays.asList(new PropertyPredicate(LIBRARY_TYPE_PROP, PropertyPredicate.ComparisonOperator.EQUAL, (Object)LibraryModel.LibraryType.LOCAL), new PropertyPredicate(LIBRARY_SERVERGUID_PROP, PropertyPredicate.ComparisonOperator.EQUAL, (Object)objRef.getServerGuid()), new PropertyPredicate(LIBRARY_ISPUBLISHED_PROP, PropertyPredicate.ComparisonOperator.EQUAL, (Object)false))).fetch();
        return this.getLibraryObjectsFromResult(librariesResult.getItems());
    }

    @type(value="Folder")
    public Collection<SubscribedLibraryData> getSubscribedLibraries(ManagedObjectReference objRef) {
        ResultSet librariesResult = this._queryService.select(new String[]{"@modelKey", NAME_PROP, DESCRIPTION_PROP, SYNC_TIME_FORMATED_PROP, SUBSCRIPTION_URL_PROP, SOURCE_LIB_PROP, STORAGE_BACKINGS}).from(new String[]{LIBRARY_MODEL}).where(LogicalOperator.AND, new PropertyPredicate[]{new PropertyPredicate(LIBRARY_TYPE_PROP, PropertyPredicate.ComparisonOperator.EQUAL, (Object)LibraryModel.LibraryType.SUBSCRIBED), new PropertyPredicate(LIBRARY_SERVERGUID_PROP, PropertyPredicate.ComparisonOperator.EQUAL, (Object)objRef.getServerGuid())}).fetch();
        return this.getLibraryObjectsForSubscribedLibFromResult(librariesResult.getItems());
    }

    private Collection<LibraryModel> getLibraryObjectsFromResult(List<ResourceItem> libraryItems) {
        ArrayList<LibraryModel> libraryModels = new ArrayList<LibraryModel>();
        for (ResourceItem libraryItem : libraryItems) {
            LibraryModel libraryModel = new LibraryModel();
            libraryModel.setId(libraryItem.getKey().toString());
            libraryModel.setName((String)libraryItem.get(NAME_PROP));
            libraryModel.setDescription((String)libraryItem.get(DESCRIPTION_PROP));
            libraryModel.setCreationTime((Calendar)libraryItem.get(CREATION_TIME_PROP));
            libraryModels.add(libraryModel);
        }
        return libraryModels;
    }

    private Collection<SubscribedLibraryData> getLibraryObjectsForSubscribedLibFromResult(List<ResourceItem> libraryItems) {
        ArrayList<SubscribedLibraryData> librariesData = new ArrayList<SubscribedLibraryData>();
        for (ResourceItem libraryItem : libraryItems) {
            SubscribedLibraryData libraryData = new SubscribedLibraryData();
            libraryData.id = libraryItem.getKey().toString();
            libraryData.name = (String)libraryItem.get(NAME_PROP);
            libraryData.description = (String)libraryItem.get(DESCRIPTION_PROP);
            libraryData.lastSyncTime = (String)libraryItem.get(SYNC_TIME_FORMATED_PROP);
            libraryData.storageBackings = (List)libraryItem.get(STORAGE_BACKINGS);
            libraryData.sourceLibrary = (URI)libraryItem.get(SOURCE_LIB_PROP);
            libraryData.subscriptionUrl = (URI)libraryItem.get(SUBSCRIPTION_URL_PROP);
            librariesData.add(libraryData);
        }
        return librariesData;
    }
}

