module common_ui {

    export interface IStorageProfileData {
        selectedProfile: StorageProfile | null;
        storageProfiles: StorageProfile[];
        error: string;
    }

    export interface IProfileId {
        uniqueId: string;
    }

    export interface IIofilterInfo {
        vibId: string;
        filterType: string;
    }

    export interface VmStorageProfileAssignment {
        vmHomeProfile: StorageProfile;
        diskProfileAssignments?: DiskStorageProfileAssignment[];
    }

    export interface DiskStorageProfileAssignment {
        diskId: string;
        profile: StorageProfile;
    }

    export interface StorageProfile {
        label: string;
        id: string | null;
        groupLabel?: string;
        profileObj?: any;
        keepExistingProfileAssignments?: boolean;
    }

    // TODO: Consume this once auto-generation is done.
    export interface ManagedObjectReference {
        type: string;
        value: string;
        serverGuid: string;
    }

    export interface StorageBaseline {
        label: string;
        id: string;
    }

    export interface StorageObjectReference extends ManagedObjectReference {
        isSdrsEnabled?: boolean;
    }

    export interface StorageLocatorBaseItem {
        storageRef: StorageObjectReference;
        name: string;
        capacity: number;
        freeSpace: number;
        provisionedSpace: number;
        thinProvisioningSupported: boolean;
        multipleHostAccess: boolean;
        hardwareAcceleration: string;
    }

    export interface StorageLocatorDatastoreItem extends StorageLocatorBaseItem {
        type: string;
        formattedType: string;
        vStorageSupported: boolean;
        parentStoragePod: StorageObjectReference;
        diskFormatsAvailable: any[];
    }

    export interface StorageLocatorStoragePodItem extends StorageLocatorBaseItem {
        drsEnabled: boolean;
        diskFormatsAvailable: any[];
    }

    export interface StorageLocatorItemsData {
        datastoreItems: StorageLocatorDatastoreItem[];
        storagePodItems: StorageLocatorStoragePodItem[];
    }
}
