/* Copyright (c) 2017-2018 VMware, Inc. All rights reserved. */
module platform {

    import ActionEvaluation = com.vmware.vise.actionsfw.ActionEvaluation;

    /**
     * Defines exposed JS APIs in namespaces.
     */
    export interface H5SdkApi {
        // Contains APIs related to the H5C application.
        app: H5SdkApplicationApi;

        // Contains APIs related to the modal dialogs.
        modal: H5SdkModalApi;

        // Contains APIs related to handling and sending events.
        event: H5SdkEventApi;
    }

    /**
     * The class initializes the html client SDK.
     */
    export class H5SdkInitializer {

        public sdk: H5SdkApi;
        private eventApiInitializer: H5SdkEventApiInitializer;

        constructor($scope: PluginIframeScope,
                    h5SdkApplicationService: H5SdkApplicationService,
                    h5SdkModalService: H5SdkModalService,
                    h5SdkEventService: H5SdkEventService) {

            this.eventApiInitializer = h5SdkEventService.createH5SdkEventApi($scope);

            let locale = $scope.viewUrlParams.locale.replace("_", "-");

            this.sdk = {
                app: h5SdkApplicationService.createH5SdkApplicationApi($scope, locale),
                modal: h5SdkModalService.createH5SdkModalApi($scope),
                event: this.eventApiInitializer.api,
            };
        }

        public onIframeUnload(): void {
            this.eventApiInitializer.onIframeUnload();
        }

        public destroy(): void {
            this.eventApiInitializer.destroy();
        }
    }

    /**
     * This service class is used to create objects of type H5SdkApi.
     * The service also takes care of the needed dependencies.
     */
    export class H5SdkApiService {

        public static $inject = [
            "h5SdkApplicationService",
            "h5SdkModalService",
            "h5SdkEventService"];

        constructor(private h5SdkApplicationService: H5SdkApplicationService,
                    private h5SdkModalService: H5SdkModalService,
                    private h5SdkEventService: H5SdkEventService) {
        }

        public getH5SdkApi(scope: PluginIframeScope): H5SdkInitializer {
            return new H5SdkInitializer(
                    scope,
                    this.h5SdkApplicationService,
                    this.h5SdkModalService,
                    this.h5SdkEventService);
        }
    }

    angular
        .module("com.vmware.platform.ui")
        .service("h5SdkApiService", H5SdkApiService);
}
