/* Copyright (c) 2017 VMware, Inc.  All rights reserved. -- VMware Confidential */

module sandbox {


   /**
    * This service is responsible for the actual communication with the plugin.
    * It has no business logic but just:
    *  - sends already prepared messages to the iframe(s)
    *  - receives messages from the iframes and pass them to the subscribed listeners
    */
   export class SandboxMessagingService {

      public static $inject = ["$window"];

      constructor(private $window: Window) {
         this.$window.addEventListener("message",
            (messageEvent) => this.receiveMessage(messageEvent), false);
      }

      private listeners: any[] = [];

      broadcastMessage(message: SandboxMessage): void {
         _.each(this.$window.frames, (iframeWindow) => iframeWindow.postMessage(message, "*"));
      }

      subscribeForMessages(listener) {
         if (this.listeners.indexOf(listener) === -1) {
            this.listeners.push(listener);
         }
      }

      private receiveMessage(message) {
         _.each(this.listeners, (listener) => listener(message.data, message.source));
      }

   }

   angular
      .module('com.vmware.platform.ui')
      .service('sandboxMessagingService', SandboxMessagingService);

}
