/* Copyright 2013 VMware, Inc. All rights reserved. -- VMware Confidential */
/**
 * Application Pinger.
 */
angular.module('com.vmware.platform.ui').factory('appPingerService', ['userSessionService', 'vxZoneService', '$rootScope',
function(userSessionService, vxZoneService, $rootScope) {
   'use strict';
   var PING_INTERVAL = 10 * 60 * 1000; // 10 mins
   var timerId = null;

   function onTimerTriggerEvent() {
       userSessionService.ping();
   }

   var pinger = {
      /**
       * Starts the application pinger.
       */
      start: function() {
         pinger.stop();

         vxZoneService.runOutsideAngular(function () {
            timerId = setInterval(onTimerTriggerEvent, PING_INTERVAL);
         });
      },

      /**
       * Stops the application pinger.
       */
      stop: function() {
         vxZoneService.runOutsideAngular(function () {
            if (timerId !== null) {
               clearInterval(timerId);
               timerId = null;
            }
         });
      }
   };

   $rootScope.$on('$destroy', function () {
      pinger.stop();
   });

   return pinger;
}]);
